/* 
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include <grts/structs.db.query.h>

#include "db_query_Editor.h"
#include <grtpp_util.h>


db_query_Editor::ImplData::ImplData()
{
}

//================================================================================
// db_query_Editor

void db_query_Editor::init()
{
  // _data must be set with set_data() by WBContextSQLIDE
  //if (!_data) _data= new db_query_Editor::ImplData(this);
}

db_query_Editor::~db_query_Editor()
{
  delete _data;
}


void db_query_Editor::set_data(ImplData *data)
{
  _data= data;
}

db_mgmt_ConnectionRef db_query_Editor::connection() const
{
  return _data->connection();
}

db_query_QueryBufferRef db_query_Editor::activeQueryBuffer() const
{
  return _data->activeQueryBuffer();
}

db_query_ResultsetRef db_query_Editor::activeResultset() const
{
  return _data->activeResultset();
}

grt::StringRef db_query_Editor::defaultSchema() const
{
  return _data->activeSchema();
}

void db_query_Editor::defaultSchema(const grt::StringRef &value)
{
  _data->activeSchema(*value);
}

db_query_QueryBufferRef db_query_Editor::addQueryBuffer()
{
  return _data->addQueryBuffer();
}


grt::IntegerRef db_query_Editor::addToOutput(const std::string &text, long bringToFront)
{
  return _data->addToOutput(text, bringToFront);
}

db_query_EditableResultsetRef db_query_Editor::createTableEditResultset(const std::string &schema, const std::string &table, const std::string &where, long showGrid)
{
  return _data->createTableEditResultset(schema, table, where, showGrid != 0);
}

grt::ListRef<db_query_Resultset> db_query_Editor::executeScript(const std::string &sql)
{
  return _data->executeScript(sql);
}


grt::IntegerRef db_query_Editor::executeScriptAndOutputToGrid(const std::string &sql)
{
  return _data->executeScriptAndOutputToGrid(sql);
}





