/* 
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef _BUG_REPORT_FORM_H_
#define _BUG_REPORT_FORM_H_

#include "workbench/wb_context_ui.h"
#include "workbench/wb_backend_public_interface.h"

#include "mforms/form.h"
#include "mforms/box.h"
#include "mforms/button.h"
#include "mforms/selector.h"
#include "mforms/textentry.h"
#include "mforms/textbox.h"
#include "mforms/checkbox.h"

/*
 * This class will be in charge of creating a form to submit a bug report
 * about the WorkBench and will validate the information needed so the 
 * bug report web page is pre-filled with the proper information
 */
class MYSQLWBBACKEND_PUBLIC_FUNC BugReportForm : public mforms::Form 
{
private:
  wb::WBContextUI *_wbui;

  mforms::Box _top_box;

  mforms::Box _credentials_box;
  mforms::Box _user_box;
  mforms::TextEntry _email;
  mforms::TextEntry _password;

  mforms::TextEntry _synopsis;
  mforms::Selector _category;
  mforms::Selector _severity;

  mforms::TextBox _description;
  mforms::TextBox _how_to_repeat;
  mforms::TextBox _internal_info;

  mforms::Box _bottom_box;
  mforms::Box _button_box;

  mforms::Button _sign_up_button;
  mforms::Button _report_button;
  mforms::Button _cancel_button;

  mforms::CheckBox _include_log;
  mforms::CheckBox _remember_password;

  std::string _sys_info;
  std::string _error_info;
  std::vector<std::string> _sys_info_list;
  std::string _os;
  std::string _os_details;
  
  std::string _version;
  std::string _really;


  void report_clicked();
  void sign_up_clicked();
  void form_closed();

  void create_credentials_box();
  void create_details_box();
  mforms::Box *create_text_section(const std::string& label, mforms::TextBox* text_box);
  void parse_sys_info();
  std::string validate_fields();

  std::string _stored_user;
  std::string _stored_password;
  bool _logged_in;
public:
  BugReportForm(wb::WBContextUI *wbui, const std::string& sys_info, const std::string &error_info);
  ~BugReportForm(void);

  void show();

};

#endif /* _BUG_REPORT_FORM_H_ */