/*
 *  MySQLWorkbench
 *
 *  Created by Max Yehorov. April 2009.
 *  Copyright 2009 Sun Microsystems Inc. All rights reserved.
 *
 */

#include "stdafx.h"

#include "grtpp.h"
#include "interfaces/plugin.h"

#include "grts/structs.workbench.model.h"


#define MODULE_VERSION "1.0.0"

#include "wb_config.h"                                                                                                                 

static grt::ListRef<app_Plugin> get_mysql_plugins_info(grt::GRT *grt);


class WbRTValidatorsModuleImpl : public grt::ModuleImplBase
{
public:
  WbRTValidatorsModuleImpl(grt::CPPModuleLoader *ldr)
  : grt::ModuleImplBase(ldr)
  {}

  DEFINE_INIT_MODULE(MODULE_VERSION, "MySQL AB", grt::ModuleImplBase,
    DECLARE_MODULE_FUNCTION(WbRTValidatorsModuleImpl::getPluginInfo), NULL);

  virtual grt::ListRef<app_Plugin> getPluginInfo()
  {
    return get_mysql_plugins_info(get_grt());
  }
};

static grt::ListRef<app_Plugin> get_mysql_plugins_info(grt::GRT *grt)
{
  grt::ListRef<app_Plugin> validators(grt);
  return validators;
}


GRT_MODULE_ENTRY_POINT(WbRTValidatorsModuleImpl);
