#include "stdafx.h"

#include "wb_config.h"

#include "grtpp.h"

#include "wb_printing.h"
#include "mdc_canvas_view_printing.h"
#include "wbcanvas/model_diagram_impl.h"

#include "grts/structs.workbench.h"



int WBPRINTINGBE_PUBLIC_FUNC wbprint::getPageCount(model_DiagramRef view)
{
  mdc::Count xc, yc;
  view->get_data()->get_canvas_view()->get_page_layout(xc, yc);

  return xc*yc;
}


void WBPRINTINGBE_PUBLIC_FUNC wbprint::getPageLayout(model_DiagramRef view, int &xpages, int &ypages)
{
  mdc::Count xc, yc;
  
  view->get_data()->get_canvas_view()->get_page_layout(xc, yc);
  xpages= xc;
  ypages= yc;
}


#ifdef _WIN32
int WBPRINTINGBE_PUBLIC_FUNC wbprint::printPageHDC(model_DiagramRef view, int pagenum, 
                                                  HDC hdc, int width, int height)
{
  mdc::CanvasViewExtras extras(view->get_data()->get_canvas_view());

  app_PageSettingsRef page(workbench_DocumentRef::cast_from(view.get_grt()->get("/wb/doc"))->pageSettings());

  extras.set_page_margins(page->marginTop(), page->marginLeft(), page->marginBottom(), page->marginRight());
  extras.set_paper_size(page->paperType()->width(), page->paperType()->height());
  extras.set_orientation(page->orientation()=="landscape"?mdc::Landscape:mdc::Portrait);
  extras.set_scale(page->scale());
  //extras.set_print_border(true);

  int pages= extras.print_native(hdc, width, height, pagenum);

  return pages;
}


bool WBPRINTINGBE_PUBLIC_FUNC wbprint::isLandscape(model_DiagramRef view)
{
  app_PageSettingsRef page(workbench_DocumentRef::cast_from(view.get_grt()->get("/wb/doc"))->pageSettings());
  return page->orientation() == "landscape";
}
#endif


