package Ocsinventory::Agent::Backend::OS::MacOS::Printers;
use strict;

use constant DATATYPE => 'SPPrintersDataType';

sub check {
    return(undef) unless -r '/usr/sbin/system_profiler';
    return(undef) unless can_load("Mac::SysProfile");
    return 1;
}

sub run {
    my $params = shift;
    my $common = $params->{common};

    my $pro = Mac::SysProfile->new();
    my $h = $pro->gettype(DATATYPE());
    return(undef) unless(ref($h) eq 'HASH');

    foreach my $printer (keys %$h){
        $common->addPrinter({
                NAME    => $printer,
                DRIVER  => $h->{$printer}->{'PPD'},
		PORT	=> $h->{$printer}->{'URI'},
        });
    }

}
1;
