/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * scales.cc
 * Copyright (C) Mark Vitek 2009 <straypacket@gmail.com>
 *
 * arpage is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * arpage is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "scales.h"

//============================================================================
//
// Each scale is just a vector of ints specifying, for scale position i, how
// many semitones to advance for scale position (i+1) % scale.size()
//
//============================================================================
scales::scales() {

   major.push_back(2);
   major.push_back(2);
   major.push_back(1);
   major.push_back(2);
   major.push_back(2);
   major.push_back(2);
   major.push_back(1);

   minor.push_back(2);
   minor.push_back(1);
   minor.push_back(2);
   minor.push_back(1);
   minor.push_back(1);
   minor.push_back(3);
   minor.push_back(1);

   harmonic.push_back(2);
   harmonic.push_back(1);
   harmonic.push_back(2);
   harmonic.push_back(2);
   harmonic.push_back(1);
   harmonic.push_back(3);
   harmonic.push_back(1);

   melodic.push_back(2);
   melodic.push_back(1);
   melodic.push_back(2);
   melodic.push_back(2);
   melodic.push_back(2);
   melodic.push_back(2);
   melodic.push_back(1);

   dorian.push_back(2);
   dorian.push_back(1);
   dorian.push_back(2);
   dorian.push_back(2);
   dorian.push_back(2);
   dorian.push_back(1);
   dorian.push_back(2);

   phrygian.push_back(1);
   phrygian.push_back(2);
   phrygian.push_back(2);
   phrygian.push_back(2);
   phrygian.push_back(1);
   phrygian.push_back(2);
   phrygian.push_back(2);

   lydian.push_back(2);
   lydian.push_back(2);
   lydian.push_back(2);
   lydian.push_back(1);
   lydian.push_back(2);
   lydian.push_back(2);
   lydian.push_back(1);

   mixolydian.push_back(2);
   mixolydian.push_back(2);
   mixolydian.push_back(1);
   mixolydian.push_back(2);
   mixolydian.push_back(2);
   mixolydian.push_back(1);
   mixolydian.push_back(2);

   aeolian.push_back(2);
   aeolian.push_back(2);
   aeolian.push_back(2);
   aeolian.push_back(2);
   aeolian.push_back(1);
   aeolian.push_back(2);
   aeolian.push_back(2);

   locrian.push_back(1);
   locrian.push_back(2);
   locrian.push_back(2);
   locrian.push_back(1);
   locrian.push_back(2);
   locrian.push_back(2);
   locrian.push_back(2);

   pentatonic.push_back(2);
   pentatonic.push_back(2);
   pentatonic.push_back(3);
   pentatonic.push_back(2);
   pentatonic.push_back(3);

   diminished.push_back(1);
   diminished.push_back(2);
   diminished.push_back(1);
   diminished.push_back(2);
   diminished.push_back(1);
   diminished.push_back(2);
   diminished.push_back(1);
   diminished.push_back(2);

   augmented.push_back(2);
   augmented.push_back(2);
   augmented.push_back(2);
   augmented.push_back(3);
   augmented.push_back(1);
   augmented.push_back(2);
}

