/* ---------------------------------------------------------------------
 * 
 * Giada - Your Hardcore Loopmachine 
 * 
 * ---------------------------------------------------------------------
 * 
 * Copyright (C) 2010-2012 Giovanni A. Zuliani | Monocasual
 * 
 * This file is part of Giada - Your Hardcore Loopmachine.
 * 
 * Giada - Your Hardcore Loopmachine is free software: you can 
 * redistribute it and/or modify it under the terms of the GNU General 
 * Public License as published by the Free Software Foundation, either 
 * version 3 of the License, or (at your option) any later version.
 * 
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it 
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see 
 * <http://www.gnu.org/licenses/>.
 * 
 * ------------------------------------------------------------------ */




#ifndef CHANNEL_H
#define CHANNEL_H


#include "utils.h"
#include "const.h"


#ifdef WITH_VST



	#ifdef __GNUC__
		#ifndef _WIN32
			#define __cdecl
		#endif
	#endif
	#include "vst/aeffectx.h"

#endif


struct channel {
	class Wave *wave;

	int    type;       
	int    index;
	float *vChan;	     
	int    status;	   
	char   side;       
	int    tracker;    
	int    start;
	int    end;
	int    startTrue;	 
	int    endTrue;	   
	float  volume;     
	float  volume_i;   
	float  volume_d;   
  float  pitch;
	float  boost;
	float  panLeft;
	float  panRight;
	int    mode;       
	bool   mute_i;     
	bool 	 mute_s;     
	bool   mute;       
	bool   solo;
	bool   qWait;      
	float  fadein;
	bool   fadeoutOn;
	float  fadeoutVol;      
	int    fadeoutTracker;  
	float  fadeoutStep;     
  int    fadeoutType;     
  int		 fadeoutEnd;      

	

	int 	 recStatus;    
  bool   readActions;  
  bool   hasActions;   

  int    key;

  gVector <class Plugin *> plugins;

  class gChannel *guiChannel;

#ifdef WITH_VST

	

	struct gVstEvents {
    int       numEvents;
    int       reserved;
    VstEvent *events[MAX_VST_EVENTS];
	} events;

#endif

};


#endif
