/* ---------------------------------------------------------------------
 * 
 * Giada - Your Hardcore Loopmachine 
 * 
 * ---------------------------------------------------------------------
 * 
 * Copyright (C) 2010-2012 Giovanni A. Zuliani | Monocasual
 * 
 * This file is part of Giada - Your Hardcore Loopmachine.
 * 
 * Giada - Your Hardcore Loopmachine is free software: you can 
 * redistribute it and/or modify it under the terms of the GNU General 
 * Public License as published by the Free Software Foundation, either 
 * version 3 of the License, or (at your option) any later version.
 * 
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it 
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see 
 * <http://www.gnu.org/licenses/>.
 * 
 * ------------------------------------------------------------------ */



#ifndef CONST_H
#define CONST_H




#define VERSIONE 				"0.7.0"
#define VERSIONE_STR 		"Giada"
#define VERSIONE_FLOAT	0.7f

#define CONF_FILENAME		"giada.conf"




#ifdef _WIN32
	#define GUI_SLEEP			1000/24
#else
	#define GUI_SLEEP			1000000/24 
#endif
#define GUI_WIDTH				810
#define GUI_HEIGHT			510

#define COLOR_BD_0     fl_rgb_color(78,  78,  78)			
#define COLOR_BD_1     fl_rgb_color(188, 188, 188)    
#define COLOR_BG_0     fl_rgb_color(37,  37,  37)     
#define COLOR_BG_1     fl_rgb_color(78,  78,  78)     
#define COLOR_BG_2     fl_rgb_color(177, 142, 142)    
#define COLOR_BG_3     fl_rgb_color(28,  32,  80)     
#define COLOR_BG_4     fl_rgb_color(113, 31,  31)     
#define COLOR_ALERT    fl_rgb_color(239, 75,  53)     
#define COLOR_TEXT_0   fl_rgb_color(200, 200, 200)
#define COLOR_TEXT_1   fl_rgb_color(25,  25,  25)
#define COLOR_BG_MAIN  fl_rgb_color(25,  25,  25)		   
#define COLOR_BG_DARK  fl_rgb_color(0,   0,   0)		   




#define MAX_BEATS				   32
#define MAX_BARS				   32
#define MAX_PATCHNAME_LEN	 32
#define DB_MIN_SCALE		   60.0f
#define MAX_VST_EVENTS     32




#define SYS_API_JACK		0x01  
#define SYS_API_ALSA		0x02  
#define SYS_API_DS			0x04  
#define SYS_API_ASIO		0x08  
#define SYS_API_CORE		0x10  
#define SYS_API_PULSE   0x20  
#define SYS_API_ANY     0x3F  

#define KERNEL_OK					 0
#define KERNEL_UNDERRUN	  -1
#define KERNEL_CRITICAL	  -2




#if defined(__linux__)
	#define DEFAULT_SOUNDSYS	SYS_API_ALSA
#elif defined(_WIN32)
	#define DEFAULT_SOUNDSYS 	SYS_API_DS
#elif defined(__APPLE__)
	#define DEFAULT_SOUNDSYS 	SYS_API_CORE
#endif

#define DEFAULT_SOUNDDEV_OUT -1      
#define DEFAULT_SOUNDDEV_IN  -1			
#define DEFAULT_SAMPLERATE   44100
#define DEFAULT_BUFSIZE		   1024
#define DEFAULT_DELAYCOMP		 0
#define DEFAULT_VOL				   0.0f
#define DEFAULT_BOOST			   0.0f
#define gDEFAULT_PITCH			 1.0f   
#define DEFAULT_OUT_VOL  	   1.0f
#define DEFAULT_IN_VOL  	   0.0f
#define DEFAULT_CHANMODE	   LOOP_BASIC
#define DEFAULT_BPM				   120.0f
#define DEFAULT_BEATS			   4
#define DEFAULT_BARS			   1
#define DEFAULT_QUANTIZE     0		  
#define DEFAULT_FADEOUT_STEP 0.01f  




#define LOOP_BASIC			0x01 
#define LOOP_ONCE				0x02 
#define	SINGLE_BASIC		0x04 
#define SINGLE_PRESS		0x08 
#define SINGLE_RETRIG		0x10 
#define LOOP_REPEAT			0x20 
#define SINGLE_ENDLESS  0x40 

#define LOOP_ANY				0x23 
#define SINGLE_ANY		  0x5C 

#define	STATUS_ENDING		0x01 
#define	STATUS_WAIT			0x02 
#define	STATUS_PLAY			0x04 
#define STATUS_OFF			0x08 
#define STATUS_EMPTY	  0x10 
#define STATUS_MISSING  0x20 
#define STATUS_WRONG    0x40 

#define REC_WAITING			0x01 
#define REC_ENDING      0x02 
#define REC_READING     0x04 
#define REC_STOPPED     0x08 




#define ACTION_MIDI       0x40 
#define ACTION_KEYPRESS		0x01 
#define ACTION_KEYREL			0x02 
#define ACTION_KILLCHAN		0x04 
#define ACTION_MUTEON			0x08 
#define ACTION_MUTEOFF		0x10 
#define ACTION_VOLUME     0x20 

#define ACTION_KEYS       0x03 
#define ACTION_MUTES      0x24 

#define RANGE_CHAR        0x01 
#define RANGE_FLOAT       0x02 




#define SAMPLE_LOADED_OK      1
#define SAMPLE_LEFT_EMPTY     0
#define SAMPLE_NOT_VALID     -1
#define SAMPLE_MULTICHANNEL  -2
#define SAMPLE_WRONG_BIT     -4
#define SAMPLE_WRONG_ENDIAN  -5
#define SAMPLE_WRONG_FORMAT  -6
#define SAMPLE_READ_ERROR    -8
#define SAMPLE_PATH_TOO_LONG -9






#define BROWSER_LOAD_PATCH   0x00
#define BROWSER_LOAD_SAMPLE  0x01
#define BROWSER_SAVE_PATCH   0x02
#define BROWSER_SAVE_SAMPLE  0x04
#define BROWSER_SAVE_PROJECT 0x08
#define BROWSER_LOAD_PLUGIN  0x10




#define CHANNEL_SAMPLE 0x01
#define CHANNEL_MIDI   0x02





#define WID_BEATS         -1
#define WID_BPM           -2
#define WID_ABOUT         -3
#define WID_FILE_BROWSER  -4
#define WID_CONFIG        -5
#define WID_FX_LIST       -6
#define WID_ACTION_EDITOR -7
#define WID_SAMPLE_EDITOR -8
#define WID_FX            -9



#define PATCH_UNREADABLE  0
#define PATCH_INVALID    -1
#define PATCH_OPEN_OK     1



#endif
