/* ---------------------------------------------------------------------
 * 
 * Giada - Your Hardcore Loopmachine 
 * 
 * ---------------------------------------------------------------------
 * 
 * Copyright (C) 2010-2012 Giovanni A. Zuliani | Monocasual
 * 
 * This file is part of Giada - Your Hardcore Loopmachine.
 * 
 * Giada - Your Hardcore Loopmachine is free software: you can 
 * redistribute it and/or modify it under the terms of the GNU General 
 * Public License as published by the Free Software Foundation, either 
 * version 3 of the License, or (at your option) any later version.
 * 
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it 
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see 
 * <http://www.gnu.org/licenses/>.
 * 
 * ------------------------------------------------------------------ */



#ifndef GE_ACTIONCHANNEL_H
#define GE_ACTIONCHANNEL_H

#include <FL/Fl.H>
#include <FL/Fl_Box.H>
#include "ge_actionWidget.h"
#include "gui_utils.h"
#include "mixer.h"
#include "recorder.h"


class gAction : public Fl_Box {
private:
	bool                  selected;
	unsigned              index;
  class gdActionEditor *parent;   
  char                  type;     

public:
	gAction(int x, int y, int h, int frame_a, unsigned index, gdActionEditor *parent, bool record, char type);
	void draw();
	int  handle(int e);
	void addAction();
	void delAction();

	

	void moveAction(int frame_a=-1);

	

	int  absx();

	

	int xToFrame_a();
	int xToFrame_b();

	int frame_a;  
	int frame_b;  

	bool onRightEdge;
	bool onLeftEdge;

	static const int MIN_WIDTH;
};





class gActionChannel : public gActionWidget {
private:

	

	gAction *getSelectedAction();

	

	gAction *selected;

	

	int actionOriginalX;
	int actionOriginalW;

	

	int actionPickPoint;


	

	bool actionCollides(int frame);

public:
	gActionChannel(int x, int y, gdActionEditor *pParent);
	void draw();
	int  handle(int e);
	void updateActions();
};


#endif
