/* ---------------------------------------------------------------------
 * 
 * Giada - Your Hardcore Loopmachine 
 * 
 * ---------------------------------------------------------------------
 * 
 * Copyright (C) 2010-2012 Giovanni A. Zuliani | Monocasual
 * 
 * This file is part of Giada - Your Hardcore Loopmachine.
 * 
 * Giada - Your Hardcore Loopmachine is free software: you can 
 * redistribute it and/or modify it under the terms of the GNU General 
 * Public License as published by the Free Software Foundation, either 
 * version 3 of the License, or (at your option) any later version.
 * 
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it 
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see 
 * <http://www.gnu.org/licenses/>.
 * 
 * ------------------------------------------------------------------ */




#ifndef GE_PIANOROLL_H
#define GE_PIANOROLL_H

#include <FL/Fl.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Box.H>
#include "ge_actionWidget.h"
#include "recorder.h"


class gPianoRollContainer : public Fl_Scroll {
private:
	class gdActionEditor *pParent;
	class gPianoRoll     *pianoRoll;

public:
	gPianoRollContainer(int x, int y, class gdActionEditor *parent);
	void draw();
	void updatePoints();
};





class gPianoRoll : public gActionWidget {
private:

	

	bool onItem();

	

	void drawSurface();

	int  push_y;
	Fl_Offscreen surface;


public:
	gPianoRoll(int x, int y, int w, class gdActionEditor *pParent);

	void draw();
	int  handle(int e);
	
	void updatePoints();
};





class gPianoItem : public Fl_Box {
private:

	

	inline int getRelY() { return y() - parent()->y() - 3; };
	inline int getRelX() { return x() - parent()->x(); };

	

	inline int getNote(int rel_y) { return 127 - (rel_y / 15); };

	

	inline int getY(int note) { return (127 * 15) - (note * 15); };


	recorder::action *a;
	recorder::action *b;
	class gdActionEditor *pParent;

	bool selected;
	int  push_x;

	 

	int  note;
	int  frame_a;
	int  frame_b;

	

	int event_a;
	int event_b;

	

	bool changed;

	

	bool onLeftEdge;
	bool onRightEdge;


public:

	

	gPianoItem(int x, int y, int rel_x, int rel_y, recorder::action *a, recorder::action *b, class gdActionEditor *pParent);

	void draw();
	int  handle(int e);
	void record();
	void remove();

	inline int getFrame_a() { return frame_a; }
	inline int getFrame_b() { return frame_b; }

};

#endif
