/* ---------------------------------------------------------------------
 * 
 * Giada - Your Hardcore Loopmachine 
 * 
 * ---------------------------------------------------------------------
 * 
 * Copyright (C) 2010-2012 Giovanni A. Zuliani | Monocasual
 * 
 * This file is part of Giada - Your Hardcore Loopmachine.
 * 
 * Giada - Your Hardcore Loopmachine is free software: you can 
 * redistribute it and/or modify it under the terms of the GNU General 
 * Public License as published by the Free Software Foundation, either 
 * version 3 of the License, or (at your option) any later version.
 * 
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it 
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see 
 * <http://www.gnu.org/licenses/>.
 * 
 * ------------------------------------------------------------------ */




#ifndef GLUE_H
#define GLUE_H



struct channel *glue_addChannel(int side, int type);



int glue_loadChannel(struct channel *ch, const char *fname, const char *fpath);

void glue_deleteChannel(struct channel *ch);

void glue_freeChannel(struct channel *ch);


int glue_loadPatch(const char *fname, const char *fpath, class gProgress *status, bool isProject);
int glue_savePatch(const char *fullpath, const char *name, bool isProject);


int glue_saveSample(int ch, const char *fullpath);



void glue_keyPress  (struct channel *ch, bool ctrl=0, bool shift=0);
void glue_keyRelease(struct channel *ch, bool ctrl=0, bool shift=0);

void glue_setBpm(const char *v1, const char *v2);
void glue_setBeats(int beats, int bars, bool expand);

void glue_startSeq();
void glue_stopSeq();
void glue_rewindSeq();



void glue_startRec();
void glue_stopRec();



int glue_startInputRec();
int glue_stopInputRec();



void glue_startReadingRecs(struct channel *ch);
void glue_stopReadingRecs(struct channel *ch);

void glue_quantize(int val);

void glue_setVol(struct channel *ch, float v);
void glue_setVolMainWin(struct channel *ch, float v);
void glue_setOutVol(float v);
void glue_setInVol(float v);

void glue_setPanning(class gdEditor *win, struct channel *ch, float val);

void glue_clearAllSamples();
void glue_clearAllRecs();



void glue_resetToInitState(bool resetGui=true);

void glue_startStopMetronome();




void glue_setBeginEndChannel(class gdEditor *win, struct channel *ch, int b, int e,
														 bool recalc=false, bool check=true);


void glue_setBoost(class gdEditor *win, struct channel *ch, float val, bool numeric);

void glue_setPitch(class gdEditor *win, struct channel *ch, float val, bool numeric);



 
void glue_setVolEditor(class gdEditor *win, struct channel *ch, float val, bool numeric);

void glue_setMute(struct channel *ch);

void glue_setSoloOn (struct channel *ch);
void glue_setSoloOff(struct channel *ch);


int glue_saveProject(const char *folderPath, const char *projName);




void glue_beatsMultiply();
void glue_beatsDivide();

#endif
