/* ---------------------------------------------------------------------
 * 
 * Giada - Your Hardcore Loopmachine 
 * 
 * ---------------------------------------------------------------------
 * 
 * Copyright (C) 2010-2012 Giovanni A. Zuliani | Monocasual
 * 
 * This file is part of Giada - Your Hardcore Loopmachine.
 * 
 * Giada - Your Hardcore Loopmachine is free software: you can 
 * redistribute it and/or modify it under the terms of the GNU General 
 * Public License as published by the Free Software Foundation, either 
 * version 3 of the License, or (at your option) any later version.
 * 
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it 
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see 
 * <http://www.gnu.org/licenses/>.
 * 
 * ------------------------------------------------------------------ */




#ifndef MIXER_H
#define MIXER_H

#include <stdlib.h>
#include <pthread.h>
#include "const.h"
#include "kernelAudio.h"
#include "utils.h"


class Mixer {
public:

	Mixer();
	~Mixer();
	void init();
	int  close();

	

	struct channel *addChannel(char side, int type);

	int  deleteChannel(struct channel *ch);
	void initChannel(struct channel *ch);
	void freeChannel(struct channel *ch);

	

	void pushChannel(class Wave *w, struct channel *ch);

	void chanStop(struct channel *ch);
	void chanReset(struct channel *ch);

	

	void fadein(channel *ch, bool internal);

	

	void fadeout(channel *ch, int actionPostFadeout=DO_STOP);

	void xfade(struct channel *ch);

	

	int getChanPos(struct channel *ch);

	

	static int masterPlay(
		void *out_buf, void *in_buf, unsigned n_frames,
		double streamTime, RtAudioStreamStatus status, void *userData
	);
	int __masterPlay(void *out_buf, void *in_buf, unsigned n_frames);

	

	void updateFrameBars();

	

	bool isSilent();

	

	bool isPlaying(struct channel *ch);

	void rewind();

	

	void updateQuanto();

	

	bool hasLogicalSamples();

	

	bool hasEditedSamples();

	

	void setPitch(struct channel *ch, float val);

	void setChanStart(struct channel *ch, unsigned val);
	void setChanEnd  (struct channel *ch, unsigned val);

	

	bool mergeVirtualInput();

	int getChannelIndex(struct channel *ch);

	channel *getChannelByIndex(int i);

	inline channel* getLastChannel() { return channels.at(channels.size-1); }


	


	enum {    
		DO_STOP   = 0x01,
		DO_MUTE   = 0x02,
		DO_MUTE_I = 0x04
	};

	enum {    
		FADEOUT = 0x01,
		XFADE   = 0x02
	};

	gVector<channel*> channels;

	bool   running;
	bool   ready;
	float *vChanInput;        
	float *vChanInToOut;      
	int    frameSize;
	float  outVol;
	float  inVol;
	float  peakOut;
	float  peakIn;
	int    quanto;
	char   quantize;
	bool	 metronome;
	float  bpm;
	int    bars;
	int    beats;
	int    waitRec; 

	bool docross;			
	bool rewindWait;	

	int framesPerBar;
	int framesPerBeat;
	int totalFrames;
	int actualFrame;
	int actualBeat;

#define TICKSIZE 38
	static float tock[TICKSIZE];
	static float tick[TICKSIZE];
	int  tickTracker, tockTracker;
	bool tickPlay, tockPlay; 

	

	channel *chanInput;

	

	int inputTracker;

	

	bool inToOut;

	pthread_mutex_t mutex_recs;
	pthread_mutex_t mutex_chans;
	pthread_mutex_t mutex_plugins;


private:

	

	void calcFadeoutStep(struct channel *ch);

	

	void calcVolumeEnv(struct channel *ch, int frame);

	

	int getNewIndex();

	

#ifdef WITH_VST
	void processPlugins(struct channel *ch);
#endif

};

#endif
