/* ---------------------------------------------------------------------
 * 
 * Giada - Your Hardcore Loopmachine 
 * 
 * ---------------------------------------------------------------------
 * 
 * Copyright (C) 2010-2012 Giovanni A. Zuliani | Monocasual
 * 
 * This file is part of Giada - Your Hardcore Loopmachine.
 * 
 * Giada - Your Hardcore Loopmachine is free software: you can 
 * redistribute it and/or modify it under the terms of the GNU General 
 * Public License as published by the Free Software Foundation, either 
 * version 3 of the License, or (at your option) any later version.
 * 
 * Giada - Your Hardcore Loopmachine is distributed in the hope that it 
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Giada - Your Hardcore Loopmachine. If not, see 
 * <http://www.gnu.org/licenses/>.
 * 
 * ------------------------------------------------------------------ */



#ifdef WITH_VST

#ifndef __PLUGIN_HOST_
#define __PLUGIN_HOST_

#include "ge_window.h"
#include "plugin.h"
#include "utils.h"
#include "init.h"
#include "const.h"


class PluginHost {

private:

	

	float **bufferI;
	float **bufferO;

	

	VstTimeInfo vstTimeInfo;

public:

	

	enum stackType {
		MASTER_OUT,
		MASTER_IN,
		CHANNEL
	};

	

	gVector <Plugin *> masterOut;
	gVector <Plugin *> masterIn;

	PluginHost();
	~PluginHost();

	int allocBuffers();

	

	static VstIntPtr VSTCALLBACK HostCallback(AEffect *effect, VstInt32 opcode, VstInt32 index, VstIntPtr value, void *ptr, float opt);
	VstIntPtr gHostCallback(AEffect *effect, VstInt32 opcode, VstInt32 index, VstIntPtr value, void *ptr, float opt);

	int addPlugin(const char *fname, int stackType, struct channel *ch=NULL);

	void processEvents(float *buffer, struct channel *ch);

	

	void processStack(float *buffer, int stackType, struct channel *ch=NULL);

	

	void processStackOffline(float *buffer, int stackType, struct channel *ch, int size);

	

	void addVstMidiEvent(struct VstMidiEvent *e, struct channel *ch);
	void addVstMidiEvent(uint32_t msg, struct channel *ch);

	

	VstMidiEvent *createVstMidiEvent(uint32_t msg);

	

	void freeVstMidiEvents(struct channel *ch, bool init=false);

	gVector <Plugin *> *getStack(int stackType, struct channel *ch=NULL);

	Plugin *getPluginById(int id, int stackType, struct channel *ch=NULL);

	Plugin *getPluginByIndex(int index, int stackType, struct channel *ch=NULL);

	int getPluginIndex(int id, int stackType, struct channel *ch=NULL);

	unsigned countPlugins(int stackType, struct channel *ch=NULL);

	void freeStack(int stackType, struct channel *ch=NULL);

	void freeAllStacks();

	void freePlugin(int id, int stackType, struct channel *ch=NULL);

	void swapPlugin(unsigned indexA, unsigned indexB, int stackType, struct channel *ch=NULL);
};
#endif

#endif 
