/*
 * 
 * Copyright (C) 2007 Ken Ellinwood.
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 * 
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 */
#ifndef __jackclient_h__
#define __jackclient_h__

/* Definitions generated by autotools. */
#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */

#ifdef __cplusplus
extern "C" {
#endif

#include <jack/jack.h>
#include <jack/types.h>

int jackclient_new(const char* client_name);
int jackclient_activate();
int jackclient_deactivate();
int jackclient_close();
    
jack_client_t* jackclient_get_client(); ///< The jack client object created by this program
    
jack_port_t* jackclient_get_port(); ///< The jack port object created by this program


/** Message struct used to send unscheduled midi control messages.
 * Messages sent in this manner are not guaranteed to be sent in any
 * particular order.  This feature is used to send sound off messages
 * as channels are muted and solo'ed.
 */
typedef struct control_message
{
    uint8_t len;
    uint8_t data[3];
} control_message_t;

/** Reserve a control message.  There is a fixed number of messages
 * available in the internal pool.  This function returns NULL if none
 * are available.
 */
control_message_t* jackclient_control_message_reserve();

/** Schedules the control message to be sent on frame 0 of the next
 * process cycle and returns the message to the pool.
 */
void jackclient_control_message_queue( control_message_t* message);    
    
#ifdef __cplusplus
}
#endif

#endif /* __jackclient_h__ */
    
