# -*- coding: utf-8 -*-
"""
This file is part of Laborejo - http://www.laborejo.org
Author: Nils Gey info@laborejo.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from os import path
import laborejocore as api

lilypondbinary = "" #use the default
pdfviewer = "" #use the default

#Load a personal config file which can overide the default config.
def reloadPersonalConfig():
    """It is important to execute this function before any other gui
    functions like generating toolbars or user menus."""
    try:
        f = open(api._getConfigDir() + "laborejo-qt.config")
        for line in f:
            if "lilypondbinary" in line or "pdfviewer" in line:
                extras = compile(line, '<string>', 'exec')
                exec(extras, locals(), globals()) #override the existing variables.
        f.close()
    except:
        pass #personal config file does not exist

