# -*- coding: utf-8 -*-
"""
This file is part of Laborejo - http://www.laborejo.org
Author: Nils Gey info@laborejo.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import laborejocore as api

def repairActiveCursor():
    """A function that hopefully will not get executed much.
    It is for situations when the activeCursor was changed during
    midi export etc. but was never changed back because an exception
    occured"""
    currentTrack = api._getActiveCursor().nested_list #this may be the wrong one. But the nested list will be the same
    score = api._getScore()
    index = next(e for e, x in enumerate(score.cursors) if x.nested_list == currentTrack)
    score.activeCursor = score.cursors[index]
    score.comeLittleCursors()

def test_material():
    """Insert 8 random quarter notes"""
    api.setCompoundTake("start")
    for i in range(8):
        api.insertChord(384, api.randomPitchHypoModeCursor())
    api.setCompoundTake("stop")

def withTest():
    api._getTrack().trackDirectiveWith["line-count"] = "\\override StaffSymbol #'line-count = #3"
    api._getTrack().trackDirectiveWith["accepts-lyrics"] = "\\accepts Lyrics"


def showSelection():
    """Show the selection which is not ordered"""
    for x in api._getScore():
        for y in x.selectedItems:
            print (y.exportLilypond())

def showData(lily = False):
    if lily:
        for x in api._getScore():
            print (x.container.exportLilypond())
    else:
        for x in api._getScore():
            for item in x:
                print (item.exportLilypond())

def testForm():
    data = {}
    data["finger"] = ("Finger", 1)
    result = api.l_form.generateForm(data, "Fingering", "Please give a finger number")
    api._finger(result["finger"])

def transtest():
    print (_("Translation Test. The language is English."))

def showUnfolded():
    workspace = api._getWorkspace()
    workspace.score = api._getScore().unfoldScore()
    api.core.session.load(workspace)
    api.l_send(lambda: api.l_global.workspaceChanged(api._getWorkspace()))
    api.l_send(lambda: api.l_global.new(api._getWorkspace()))

