# -*- coding: utf-8 -*-
"""
This file is part of Laborejo - http://www.laborejo.org
Author: Nils Gey info@laborejo.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

import laborejocore as api

#Substitutions
#The substitutions themselves are not here but in substitutiondatabase.py and saved in each score.
def substitution(keyword):
    def do():
        i = api._getCursorItem()
        if type(i) is api.items.Chord:
            i.substitution = keyword
    api.command(do, signal = api.l_chord.substitutionMarker)

""" #The gui did use the the cursor position in the end.
def substitutionRemote(item, keyword):
    if type(item) is api.items.Chord:
        item.substitution = keyword
        api.l_send(api.l_item.updateDynamic(item)
"""

def substitutionDelete():
    """Delete the substitution string from the current chord"""
    def do():
        i = api._getCursorItem()
        if isinstance(i, api.items.Chord):
            i.substitution = None
    api.command(do, signal = api.l_chord.substitutionMarker)

#All substitutions have to go through these two.
def substitutionsScoreAdd(key, container):
    """Add a new subst. to this score.
    Silently overwrite if key exists."""
    api._getScore().substitutions[key] = container
    api.l_send(api.l_score.substitutionsChanged)


def substitutionsScoreDelete(key = None):
    if not key:
        api._deleteFromDictWithGui(api._getScore().substitutions, _("Delete Substitution from this score"), _("Choose which Substitution to delete.\n\nChoose 'Delete All' to override\nall individual choices and\nsimply delete all substitutions."))
        api.l_send(api.l_score.substitutionsChanged)
    else:
        del api._getScore().substitutions[key]
        api.l_send(api.l_score.substitutionsChanged)

def substitutionScoreFromSelection(key = None, unfold = True):
    if not key:
        ret = api.l_form.generateForm({"01Name" : (_("Name"),""), "02Group" : (_("Group (optional)"), ""), "03Unfold" : (_("Unfold"), True)}, _("Create Substitution from Selection"), _("Choose a name and an optional group name.\n Uncheck unfold if you don't want Lilypond output, only Playback."))
        if ret:
            key = ret["01Name"]
            group = ret["02Group"]
            unfold = ret ["03Unfold"]
    if key: #gui and user did not cancel.
        cont = api.containerFromSelection()
        cont.unfold = unfold
        cont.group = group
        cont._uniqueContainerName = key
        substitutionsScoreAdd(key, cont)

def substitutionsScoreFromFile(filepath):
    """Load a Laborejo save file and for any track create a substitution
    with the unique trackname as key and the inverted track.hideLilypond
    as unfold. track.group is used as substitution group name."""
    tempWorkspace = api.saveload.load(filepath)
    tempWorkspace.score.removeEmptyTracks()
    for track in tempWorkspace.score.container:
        curwsp = api._getWorkspace()
        newCont = api.core.Container(curwsp)
        for i in track.container:
            i.parentWorkspace = curwsp

        if track.container[0] is api.items.Start:
            newCont.container = track.container
        else:
            newCont.container = newCont[:1] + track.container + newCont[-1:] #Start() and End()
        newCont.unfold = not track.hideLilypond
        newCont.group = track.group
        newCont._uniqueContainerName = track.uniqueContainerName
        substitutionsScoreAdd(track.uniqueContainerName, newCont)
    api.l_send(api.l_score.substitutionsChanged)

def substitutionsScoreToFile(filepath = None):
    tmpSubst = api._getScore().substitutions
    api.new(filepath) #also changes all active cursors and such to the new file.
    for key, container in tmpSubst.items():
        tr = api._getTrack()
        tr.hideLilypond = not container.unfold
        tr.group = container.group
        tr._uniqueContainerName = container.uniqueContainerName
        for item in [i for i in container.container[1:-1]]:
            api._pasteItem(item, standaloneInsert = True)
        api.trackAdd()
    if not api._getTrackIndex() == 0:
        api.trackDelete(justDelete = True) #remove the last track which is empty. No warning for the gui.

    if filepath:
        api.save(filepath)

def substitutionUnfold():
    """Replace an item with its substitution permanently.
    This means deleting the original note and pasting new notes
    from the container."""
    def do(i):
        replaceCont = i.unfoldSubstitution(api._getKeysig())
        for item in replaceCont:
            api._insert(item)

    if api._getScore().selection:  #there is at least one selected item?
        def test(item, cursor):
            if item.selected and type(item) is api.items.Chord and item.substitution:
                return True
        replace(test, lambda item: do(item), selectNewItems = False) #don't select the new items by replace. We do it ourselves.
    else:
        def tmp():
            i = api._getCursorItem()
            if i.substitution:
                api.delete()
                do(i)
        api.command(tmp)
