# -*- coding: utf-8 -*-
"""
This file is part of Laborejo - http://www.laborejo.org
Author: Nils Gey info@laborejo.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

"""
In this file we have ultra high-level functions which to combine several
API features.
We can call these macros in here as well.
There is very little calculation and no need for any function parameters
just calling one api function after another.
"""

import laborejocore as api
from os.path import dirname, join, abspath
me = dirname(__file__) #laborejocore/api
root = abspath(join(me, "..", "templates", "trackgroups"))

def fromFile(filepath):
    """Load a Laborejo save file as template but add the tracks
    to the current file, not into a new one."""
    api.notDuringUndo = False #don't register any undos during the next steps. Because adding tracks can't be undone.
    tempWorkspace = api.saveload.load(filepath, loadAsTemplate = True)
    for track in tempWorkspace.score.container:
        api._getScore().addTrack(tr = track)


        #new midi channel
        api.l_send(lambda: api.l_score.addLastTrack(track))
        api.l_send(lambda: api.l_score.fillTrack(track))
        api.l_send(api.l_score.trackChanged)
    api.tail() #in the last track. Just an insurance that everything is indeed on the right position.
    api.notDuringUndo = True #start undo recording again.



#Insert complete tracks as template including staff groups and internal midi settings.

def insertPiano():
    fromFile(join(root, "piano.lbjs"))

def insertStringsOrchestra():
    fromFile(join(root, "strings-orchestra.lbjs"))

def insertStringsQuartet():
    fromFile(join(root, "strings-quartet.lbjs"))

def insertChoirTwoStaffs():
    fromFile(join(root, "choir-two-staffs.lbjs"))

def insertChoirFourStaffs():
    fromFile(join(root, "choir-four-staffs.lbjs"))


#Recorder Ensemble
#Bands etc.
#There needs to be a line between complete setups (Load as Template) and building blocks.
