# -*- coding: utf-8 -*-
"""
This file is part of Laborejo - http://www.laborejo.org
Author: Nils Gey info@laborejo.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""


#No external dependencies here. These are just plain python functions,
#ready to use in any program.

def num2word(n):
    """Take a number, return a str.
    Lilypond does not allow numbers in variable names"""
    return ''.join(chr(ord(c)+17) for c in str(n))


def num2wordForIterations(stringOrNum):
    if stringOrNum in [1,2,3,4,5,6,7,8,9,0] or stringOrNum in "1234567890":
        return num2word(int(stringOrNum))
    elif stringOrNum in ("-", "_"):
        return ""
    else:
        return stringOrNum

def stringToCharsOnlyString(string):
    return "".join([num2wordForIterations(c) for c in string])

def toLyString(string):
    if value.strip().startswith("\\markup"):
        return string
    else:
        return '"' + '"'

def lyTwoLiner(first, second, align = None):
    """Return a lilypod two liner in lilypond markup syntax.
    make sure the strings are already translated"""
    column = {"left": "\\left-column", "center": "\\center-column", "right": "\\right-column", None : "\\column", }
    return "\\markup "+ column[align] +" { \\line { " + first + " } \\line { " + second + " } }"

def items2types(lst):
    """Take a flat list of items and return a list of types instead"""
    return [type(it) for it in lst]

def flatten(lst):
    """Take a nested list of any depth and make it a flat, plain
    list with only one level"""
    l = []
    for elem in lst:
        if type(elem) in (tuple, list):
            for i in flatten(elem):
                l.append(i)
        else:
            l.append(elem)
    return l
