# -*- coding: utf-8 -*-
"""
This file is part of Laborejo - http://www.laborejo.org
Author: Nils Gey info@laborejo.org

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from laborejocore.core import Container
from laborejocore.items import Start, End, Chord
from laborejocore.lilypond import ly2pitch


"""
The group is only used for documentation and for possible guis. You can
use None or an Empty String if you want.

The substitution has always 1420, c' as reference pitch.

9 and 0 are second and third plus octave. But this is only a a naming
convention.
"""

###These will NEVER be replaced by an editable file. We guarantee that these will sound the same on every system in every laborejo version. editable files are not possible here.

def build_database(parentWorkspace):
    subst_laborejo = {}

    def create(nameString, chordTuples, group = ""):
        """You can use chordTuples or just simple pitch ints. Don't mix.
        Also possible: absolute lilpond pitches as a list"""
        n = Container(parentWorkspace = parentWorkspace)
        if type(chordTuples[0]) is int:
            n.container = [Start(parentWorkspace, n)] + [Chord(parentWorkspace, 384, tup) for tup in chordTuples] + [End(parentWorkspace, n)]
        elif type(chordTuples[0]) is str:
            n.container = [Start(parentWorkspace, n)] + [Chord(parentWorkspace, 384, ly2pitch[tup]) for tup in chordTuples] + [End(parentWorkspace, n)]
        else:
            n.container = [Start(parentWorkspace, n)] + [Chord(parentWorkspace, tup[0], tup[1]) for tup in chordTuples] + [End(parentWorkspace, n)]
        n.group = group if group else ""
        n._uniqueContainerName = "subst_" + nameString
        subst_laborejo[nameString] = n


    create("1231", [1420, 1470, 1520, 1420] ,"boundaryNotes")
    create("8768", [1420, 1370, 1320, 1420] ,"boundaryNotes")
    create("123", [1420, 1470, 1520] ,"triplets")
    create("121", [1420, 1470, 1420] ,"triplets")
    create("131", [1420, 1520, 1420] ,"triplets")
    create("12345", [1420, 1470, 1520, 1570, 1620] ,"quintuplets")
    create("321", [1420, 1370, 1320] ,"triplets")
    create("r211", [(384, 1420), (192, 1420), (192, 1420), ] , "sameNote")
    create("135653", "c' e' g' a' g' e'".split() , "arpeggios")
    create("FF-2oct", "c' d' e' g' c'' d'' e'' g'' c''' g'' e'' d'' c'' g' e' d'".split() , "arpeggios")
    create("FF-4oct", """c' d' e' g'
                         c'' d'' e'' g''
                         c''' d''' e''' g'''
                         c'''' d'''' e'''' g''''

                         c''''' g''''  e'''' d''''
                         c'''' g''' e''' d'''
                         c''' g'' e'' d''
                         c'' g' e' d'
                         """.split() , "arpeggios")
    return subst_laborejo
