 ###############################################################################
 #  Copyright 2008 Ian McIntosh <ian@openanswers.org>
 #
 #  This program is free software; you can redistribute it and/or modify
 #  it under the terms of the GNU General Public License as published by
 #  the Free Software Foundation; either version 2 of the License, or
 #  (at your option) any later version.
 #
 #  This program is distributed in the hope that it will be useful,
 #  but WITHOUT ANY WARRANTY; without even the implied warranty of
 #  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 #  GNU Library General Public License for more details.
 #
 #  You should have received a copy of the GNU General Public License
 #  along with this program; if not, write to the Free Software
 #  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ###############################################################################

require 'osc_server'
require 'callbacks'

class MessageBus < OSCServer
	include Callbacks

	# button/slider value changes
	callback :button_down
	callback :button_up
	callback :slider_change

private

	def on_new_message(address, value)
		if value.is_a? Float
			slider_change_notify(address, (value > 1.0) ? 1.0 : ((value < 0.0) ? 0.0 : value))
		elsif value.is_a? Integer
			if value >= 1
				button_down_notify(address)
			else
				button_up_notify(address)
			end
		else
			@ignored_message_count += 1
		end
	end
end
