 ###############################################################################
 #  Copyright 2012 Ian McIntosh <ian@openanswers.org>
 #
 #  This program is free software; you can redistribute it and/or modify
 #  it under the terms of the GNU General Public License as published by
 #  the Free Software Foundation; either version 2 of the License, or
 #  (at your option) any later version.
 #
 #  This program is distributed in the hope that it will be useful,
 #  but WITHOUT ANY WARRANTY; without even the implied warranty of
 #  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 #  GNU Library General Public License for more details.
 #
 #  You should have received a copy of the GNU General Public License
 #  along with this program; if not, write to the Free Software
 #  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 ###############################################################################

class ActorEffectActorBrush < ActorEffect
	title				'Actor Brush'

	setting 'actor', :actor, :summary => true

	setting 'offset_x', :float, :default => 0.0..1.0
	setting 'offset_y', :float, :default => 0.0..1.0

	setting 'period', :float, :default => 0.01..1.0
	setting 'opacity', :float, :default => 1.0..1.0
	setting 'scale', :float, :default => 1.0..1.0

	setting 'maximum_per_frame', :integer, :range => 1..1000, :default => 50..1000

	def render
		return yield if scale == 0.0

		actor.one { |a|
			parent_user_object.using {
				with_alpha(opacity) {
					prev_x = offset_x_setting.last_value
					prev_y = offset_y_setting.last_value

					delta_x = offset_x - prev_x
					delta_y = offset_y - prev_y

					prev_scale = scale_setting.last_value
					delta_scale = (scale - prev_scale)

					distance = Math.sqrt(delta_x*delta_x + delta_y*delta_y)
					count = ((distance / scale) / period).floor

					count = maximum_per_frame if count > maximum_per_frame

					if count < 2
						with_translation(offset_x, offset_y) {
							with_scale(scale) {
								a.render!
							}
						}
					else
						step_x = delta_x / count
						step_y = delta_y / count

						step_scale = delta_scale / count

						beat_delta = $env[:beat_delta]
						for i in 1..count
							progress = (i.to_f / count)
							with_beat_shift(-beat_delta * (1.0 - progress)) {
								with_translation(prev_x + step_x*i, prev_y + step_y*i) {
									with_scale(prev_scale + step_scale*i) {
										a.render!
									}
								}
							}
						end
					end
				}
			}
		}
		yield
	end
end
