/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQICONSET_H
#define TQT_TQICONSET_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the QAccel class
// For Qt3, no changes are needed

#include <qiconset.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the QAccel class
// For Qt4, some changes are needed

#include <tqt4/Qt/qicon.h>
#include <Qt/q3shared.h>

class TQIconFactory : private Q3Shared
{
public:
    TQIconFactory();
    virtual ~TQIconFactory();

    virtual QPixmap *createPixmap( const QIconSet& iconSet, QIconSet::Size size,
				   QIconSet::Mode mode, QIconSet::State state );
    void setAutoDelete( bool autoDelete ) { autoDel = autoDelete; }
    bool autoDelete() const { return autoDel; }

    static TQIconFactory *defaultFactory();
    static void installDefaultFactory( TQIconFactory *factory );

private:
#if defined(Q_DISABLE_COPY)
    TQIconFactory( const TQIconFactory & );
    TQIconFactory &operator=( const TQIconFactory & );
#endif

    uint autoDel : 1;
    uint unused : 31;
};

#endif // USE_QT4

#endif /* TQT_TQICONSET_H */