/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQPAIR_H
#define TQT_TQPAIR_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the QPair class
// For Qt3, no changes are needed

#include <qpair.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the QPair class
// For Qt4, some changes are needed

#include <Qt/qpair.h>

/****************************************************************************
**
** Definition of TQPair class
**
**
** Copyright (C) 1992-2005 Trolltech AS.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

template <class T1, class T2>
struct TQPair
{
    typedef T1 first_type;
    typedef T2 second_type;

    TQPair()
	: first( T1() ), second( T2() )
    {}
    TQPair( const T1& t1, const T2& t2 )
	: first( t1 ), second( t2 )
    {}

    TQPair<T1, T2>& operator=(const TQPair<T1, T2>& other)
    {
	if (this != &other) {
	    first = other.first;
	    second = other.second;
	}
	return *this;
    }

    T1 first;
    T2 second;
};

template <class T1, class T2>
bool operator==( const TQPair<T1, T2>& x, const TQPair<T1, T2>& y )
{
    return x.first == y.first && x.second == y.second;
}

template <class T1, class T2>
bool operator<( const TQPair<T1, T2>& x, const TQPair<T1, T2>& y )
{
    return x.first < y.first ||
	   ( !( y.first < x.first ) && x.second < y.second );
}

template <class T1, class T2>
TQPair<T1, T2> qMakePair( const T1& x, const T2& y )
{
    return TQPair<T1, T2>( x, y );
}

#ifndef QT_NO_DATASTREAM
template <class T1, class T2>
inline QDataStream& operator>>( QDataStream& s, TQPair<T1, T2>& p )
{
    s >> p.first >> p.second;
    return s;
}

template <class T1, class T2>
inline QDataStream& operator<<( QDataStream& s, const TQPair<T1, T2>& p )
{
    s << p.first << p.second;
    return s;
}
#endif

/**********************************************************************/

#endif // USE_QT4

#endif /* TQT_TQPAIR_H */