/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQCLEANUPHANDLER_H
#define TQT_TQCLEANUPHANDLER_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the QCleanupHandler class
// For Qt3, no changes are needed

#include <ntqcleanuphandler.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the QCleanupHandler class
// For Qt4, some changes are needed

//#include <Qt/ntqcleanuphandler.h>

#include "tntqptrlist.h"

template<class Type>
class TQCleanupHandler
{
public:
    TQCleanupHandler() : cleanupObjects( 0 ) {}
    ~TQCleanupHandler() { clear(); }

    Type* add( Type **object ) {
	if ( !cleanupObjects )
	    cleanupObjects = new Q3PtrList<Type*>;
	cleanupObjects->insert( 0, object );
	return *object;
    }

    void remove( Type **object ) {
	if ( !cleanupObjects )
	    return;
	if ( cleanupObjects->findRef( object ) >= 0 )
	    (void) cleanupObjects->take();
    }

    bool isEmpty() const {
	return cleanupObjects ? cleanupObjects->isEmpty() : TRUE;
    }

    void clear() {
	if ( !cleanupObjects )
	    return;
	Q3PtrListIterator<Type*> it( *cleanupObjects );
	Type **object;
	while ( ( object = it.current() ) ) {
	    delete *object;
	    *object = 0;
	    cleanupObjects->remove( object );
	}
	delete cleanupObjects;
	cleanupObjects = 0;
    }

private:
    Q3PtrList<Type*> *cleanupObjects;
};

template<class Type>
class TQSingleCleanupHandler
{
public:
    TQSingleCleanupHandler() : object( 0 ) {}
    ~TQSingleCleanupHandler() {
	if ( object ) {
	    delete *object;
	    *object = 0;
	}
    }
    Type* set( Type **o ) {
	object = o;
	return *object;
    }
    void reset() { object = 0; }
private:
    Type **object;
};

template<class Type>
class TQSharedCleanupHandler
{
public:
    TQSharedCleanupHandler() : object( 0 ) {}
    ~TQSharedCleanupHandler() {
	if ( object ) {
	    if ( (*object)->deref() )
		delete *object;
	    *object = 0;
	}
    }
    Type* set( Type **o ) {
	object = o;
	return *object;
    }
    void reset() { object = 0; }
private:
    Type **object;
};

#endif // USE_QT4

#endif /* TQT_TQCLEANUPHANDLER_H */