/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqcommonstyle.h>

#ifdef USE_QT4

// void QCommonStyle::drawPrimitive(ControlElement element, const QStyleOption *opt, QPainter *p, const QWidget *w) const {
// 	drawControl(element, opt, p, w);
// }

void QCommonStyle::drawPrimitive( PrimitiveElement pe,
			Q3Painter *p,
			const QRect &r,
			const QColorGroup &cg,
			SFlags flags,
			const QStyleOption& opt) const {
	drawPrimitive(pe, &opt, (QPainter*)p);
}

void QCommonStyle::drawControl( ControlElement element,
			Q3Painter *p,
			const QWidget *widget,
			const QRect &r,
			const QColorGroup &cg,
			SFlags how,
			const QStyleOption& opt) const {

	drawControl(element, &opt, (QPainter*)p, widget);
}

void QCommonStyle::drawComplexControl( ComplexControl control,
			     Q3Painter *p,
			     const QWidget *widget,
			     const QRect &r,
			     const QColorGroup &cg,
			     SFlags how,
			     SCFlags sub,
			     SCFlags subActive,
			     const QStyleOption& opt ) const {
	drawComplexControl(control, (QStyleOptionComplex*)&opt, (QPainter*)p, widget);
}

int QCommonStyle::styleHint(StyleHint sh, const QWidget * widget, const QStyleOption &opt, QStyleHintReturn *shret) const {
	return styleHint(sh, &opt, widget,  shret);
}

QPixmap QCommonStyle::stylePixmap( StandardPixmap stylepixmap, const QWidget *widget, const QStyleOption& opt) const {
	return standardPixmap(stylepixmap, &opt, widget);
}

QRect QCommonStyle::querySubControlMetrics( ComplexControl control,
			const QWidget *widget,
			SubControl sc,
			const QStyleOption& opt) const {
	return subControlRect(control, (QStyleOptionComplex*)&opt, sc, widget);
}

QRect QCommonStyle::subRect( SubElement r, const QWidget *widget ) const {
	QStyleOption opt = QStyleOption::SO_Default;
	return subElementRect(r, &opt, widget);
}

int QCommonStyle::pixelMetric( PixelMetric m, const QWidget *widget ) const {
	QStyleOption opt = QStyleOption::SO_Default;
	return pixelMetric(m, &opt, widget);
}

QCommonStyle::SubControl QCommonStyle::querySubControl( ComplexControl control,
			const QWidget *widget,
			const QPoint &pos,
			const QStyleOption& opt ) const {
	return hitTestComplexControl(control, (QStyleOptionComplex*)&opt, pos, widget);
}

#endif // USE_QT4