/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQEVENTLOOP_H
#define TQT_TQEVENTLOOP_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the QEventLoop class
// For Qt3, no changes are needed

#include <ntqeventloop.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the QEventLoop class
// For Qt4, some changes are needed

#include <Qt/ntqeventloop.h>
#include <Qt/qabstracteventdispatcher.h>

class TQEventLoop : public QAbstractEventDispatcher, QEventLoop {
public:
	static TQEventLoop *eventLoop ();

	enum ProcessEvents {
		AllEvents		= QEventLoop::AllEvents,
		ExcludeUserInput	= QEventLoop::ExcludeUserInputEvents,
		ExcludeSocketNotifiers	= QEventLoop::ExcludeSocketNotifiers,
		WaitForMore		= QEventLoop::WaitForMoreEvents
	};

	typedef uint ProcessEventsFlags;

	bool processEvents( ProcessEventsFlags flags );

};

#endif // USE_QT4

#endif /* TQT_TQEVENTLOOP_H */