/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQIMAGE_H
#define TQT_TQIMAGE_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the QImage class
// For Qt3, no changes are needed

#include <ntqimage.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the QImage class
// For Qt4, some changes are needed

#include <tqt4/Qt/ntqimage.h>
#include <Qt/qimagereader.h>
#include <Qt/qimagewriter.h>

class TQImageIO {
public:
	TQImageIO();
	TQImageIO( QIODevice	 *ioDevice, const char *format );
	TQImageIO( const QString &fileName, const char* format );
	~TQImageIO();

	bool	read();
	bool	write();

	const QImage &image() const;
	void setImage( const QImage & );

protected:
	QImageReader *m_imageReader;
	QImageWriter *m_imageWriter;

	QImage m_currentImage;
};

#endif // USE_QT4

#endif /* TQT_TQIMAGE_H */