/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqiodevice.h>

#ifdef USE_QT4

void QIODevice::setState( int s ) {
	if (s == IO_Open) {
		if (isOpen() == false) {
			open(openMode());
		}
	}
}

void QIODevice::setFlags( int f ) {
	setOpenMode((OpenMode)f);
}

void QIODevice::setStatus( int s ) {
	#warning "QIODevice::setStatus is unimplemented!"
}

// TQIODevice::TQIODevice() : QIODevice() {}
//
// qint64 TQIODevice::readData(char *data, qint64 maxlen) {
// 	return read(data, maxlen);
// }
//
// qint64 TQIODevice::writeData(const char *data, qint64 len) {
// 	return write(data, len);
// }

// qint64 QIODevice::readData(char *data, qint64 maxlen) {
// 	return read(data, maxlen);
// }
//
// qint64 QIODevice::writeData(const char *data, qint64 len) {
// 	return write(data, len);
// }

qint64 QIODevice::readLine(QString & s, qint64 maxlen) {
	qint64 ret;
	QByteArray q;

	readLine(q.data(), maxlen);
	s.setAscii(q);
	return ret;
}

#endif // USE_QT4