/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqmenudata.h>

#ifdef USE_QT4

Q3PopupMenu *QMenuItem::popup() const {
    #warning "Badly broken/nonfunctional QMenuItem::popup() implementation!"
    return &Q3PopupMenu(menu());
}

/*!
    \overload

    Inserts a menu item that consists of the widget \a widget with
    optional id \a id, and optional \a index position.

    Ownership of \a widget is transferred to the popup menu or to the
    menu bar.

    Theoretically, any widget can be inserted into a popup menu. In
    practice, this only makes sense with certain widgets.

    If a widget is not focus-enabled (see
    \l{QWidget::isFocusEnabled()}), the menu treats it as a separator;
    this means that the item is not selectable and will never get
    focus. In this way you can, for example, simply insert a QLabel if
    you need a popup menu with a title.

    If the widget is focus-enabled it will get focus when the user
    traverses the popup menu with the arrow keys. If the widget does
    not accept \c ArrowUp and \c ArrowDown in its key event handler,
    the focus will move back to the menu when the respective arrow key
    is hit one more time. This works with a QLineEdit, for example. If
    the widget accepts the arrow key itself, it must also provide the
    possibility to put the focus back on the menu again by calling
    QWidget::focusNextPrevChild(). Futhermore, if the embedded widget
    closes the menu when the user made a selection, this can be done
    safely by calling:
    \code
	if ( isVisible() &&
	     parentWidget() &&
	     parentWidget()->inherits("QPopupMenu") )
	    parentWidget()->close();
    \endcode

    Returns the allocated menu identifier number (\a id if \a id >= 0).

    \sa removeItem()
*/
int QMenu::insertItem( QWidget* widget, int id, int index )
{
    #warning "QMenuData::insertItem(QWidget* widget, int id, int index) unimplemented!"

    // New method is const QIcon*, const QString*, const QObject*, const char*, const QKeySequence*, const QMenu*, int, int
    // Qt4 does not seem to support arbitrary widgets being added to menus (!!!)
    // This will need to be reimplemented somehow as it is a very useful feature (e.g. Start menu text filter box)
    //return insertAny( 0, 0, 0, 0, id, index, widget );
    return insertAny( 0, &QString("UNIMPLEMENTED"), widget, 0, 0, 0, id, index );
}

#endif // USE_QT4