/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqpixmap.h>

#ifdef USE_QT4

#include <Qt/ntqbitmap.h>
#include <qt4/QtGui/private/qpixmapdata_p.h>

bool QPixmap::convertFromImage(const QImage &img, int flags) {
	return convertFromImage(img, (Qt::ImageConversionFlags)flags);
}

QPixmap::Optimization QPixmap::optimization() const {
	#warning "QPixmap::optimization() unimplemented!"
	return QPixmap::NormalOptim;
}

void QPixmap::setOptimization( QPixmap::Optimization ) {
	#warning "QPixmap::setOptimization unimplemented!"
}

QPixmap::Optimization defaultOptimization() {
	#warning "QPixmap::Optimization unimplemented!"
	return QPixmap::NormalOptim;
}

void QPixmap::setDefaultOptimization( QPixmap::Optimization ) {
	#warning "QPixmap::setDefaultOptimization unimplemented!"
}

QPixmap::QPixmap( int w, int h, int depth, Optimization optim ) {
	QPixmap(w, h);
}

QPixmap::operator QPixmap *() const {
	return const_cast<QPixmap *>(this);
}

const QBitmap *QPixmap::ptrmask() const {
	QBitmap pm = mask();
	QBitmap *pr = &pm;
	return pr;
}

#endif // USE_QT4