/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#ifndef TQT_TQSTRLIST_H
#define TQT_TQSTRLIST_H

#include <tqt.h>

#ifdef USE_QT3

// Reimplement the TQStrList class
// For Qt3, no changes are needed

#include <ntqstrlist.h>

#endif // USE_QT3

#ifdef USE_QT4

// Reimplement the TQStrList class
// For Qt4, some changes are needed

#include <ntqptrlist.h>
#include <Qt/q3strlist.h>
#include <Qt/q3ptrcollection.h>

/****************************************************************************
**
** Definition of TQStrList, TQStrIList and TQStrListIterator classes
**
** Created : 920730
**
** Copyright (C) 1992-2008 Trolltech ASA.  All rights reserved.
**
** This file is part of the tools module of the Qt GUI Toolkit.
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
** Alternatively you may (at your option) use any later version
** of the GNU General Public License if such license has been
** publicly approved by Trolltech ASA (or its successors, if any)
** and the KDE Free Qt Foundation.
**
** Please review the following information to ensure GNU General
** Public Licensing requirements will be met:
** http://trolltech.com/products/qt/licenses/licensing/opensource/.
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
** or contact the sales department at sales@trolltech.com.
**
** This file may be used under the terms of the Q Public License as
** defined by Trolltech ASA and appearing in the file LICENSE.QPL
** included in the packaging of this file.  Licensees holding valid Qt
** Commercial licenses may use this file in accordance with the Qt
** Commercial License Agreement provided with the Software.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#if defined(Q_QDOC)
class TQStrListIterator : public TQPtrListIterator<char>
{
};
#else
typedef TQPtrListIterator<char> TQStrListIterator;
#endif

class TQStrList : public TQPtrList<char>
{
public:
    TQStrList( bool deepCopies=TRUE ) { dc = deepCopies; del_item = deepCopies; }
    TQStrList( const TQStrList & );
    ~TQStrList()			{ clear(); }
    TQStrList& operator=( const TQStrList & );

    // Interoperability
    TQStrList(Q3StrList& l)
    {
        for (unsigned int i = 0; i < l.count(); ++i) append(l.at(i));
    }

    TQStrList& operator= (Q3StrList& l)
    {
        this->clear();
        for (unsigned int i = 0; i < l.count(); ++i) append(l.at(i));
        return *this;
    }

    operator Q3StrList() {
        Q3StrList list;
        for (TQStrList::const_iterator it = TQStrList::constBegin();
             it != TQStrList::constEnd(); ++it)
            list.append(*it);
        return list;
    }

    operator Q3StrList() const {
        Q3StrList list;
        for (TQStrList::const_iterator it = TQStrList::constBegin();
             it != TQStrList::constEnd(); ++it)
            list.append(*it);
        return list;
    }

    // More interoperability
    // Should convert to and from a QList<QByteArray>
    TQStrList(const QList<QByteArray> &list) {
        for (int i = 0; i < list.size(); ++i)
            append(list.at(i).constData());
    }

    TQStrList &operator =(const QList<QByteArray> &list) {
        clear();
        for (int i = 0; i < list.size(); ++i)
            append(list.at(i).constData());
        return *this;
    }

    operator QList<QByteArray>() const {
        QList<QByteArray> list;
        for (TQPtrListStdIterator<char> it = begin(); it != end(); ++it)
            list.append(QByteArray(*it));
        return list;
    }

private:
    Q3PtrCollection::Item newItem( Q3PtrCollection::Item d ) { return dc ? qstrdup( (const char*)d ) : d; }
    void deleteItem( Q3PtrCollection::Item d ) { if ( del_item ) delete[] (char*)d; }
    int compareItems( Q3PtrCollection::Item s1, Q3PtrCollection::Item s2 ) { return qstrcmp((const char*)s1,
							 (const char*)s2); }
#ifndef QT_NO_DATASTREAM
    QDataStream &read( QDataStream &s, Q3PtrCollection::Item &d )
				{ s >> (char *&)d; return s; }
    QDataStream &write( QDataStream &s, Q3PtrCollection::Item d ) const
				{ return s << (const char *)d; }
#endif
    bool  dc;
};


class TQStrIList : public TQStrList	// case insensitive string list
{
public:
    TQStrIList( bool deepCopies=TRUE ) : TQStrList( deepCopies ) {}
    ~TQStrIList()			{ clear(); }
private:
    int	  compareItems( Q3PtrCollection::Item s1, Q3PtrCollection::Item s2 )
				{ return qstricmp((const char*)s1,
						    (const char*)s2); }
};


inline TQStrList & TQStrList::operator=( const TQStrList &strList )
{
    clear();
    dc = strList.dc;
    del_item = dc;
    TQPtrList<char>::operator=( strList );
    return *this;
}

inline TQStrList::TQStrList( const TQStrList &strList )
    : TQPtrList<char>( strList )
{
    dc = FALSE;
    operator=( strList );
}

/**********************************************************************/

#endif // USE_QT4

#endif /* TQT_TQSTRLIST_H */