// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "tree.h"
/**
   // Global callback event counter
*/
static int G_cb_counter = 0; 

/**
   Return an Fl_Tree_Reason as a text string name
*/
const char* reason_as_name(Fl_Tree_Reason reason) {
  switch ( reason ) {
        case FL_TREE_REASON_NONE:       return("none");
        case FL_TREE_REASON_SELECTED:   return("selected");
        case FL_TREE_REASON_DESELECTED: return("deselected");
        case FL_TREE_REASON_OPENED:     return("opened");
        case FL_TREE_REASON_CLOSED:     return("closed");
        default:                        return("???");
      }
}

void Button_CB(Fl_Widget*w, void*data) {
  fprintf(stderr, "'%s' button pushed\n", w->label());
}

/**
   Assign user icons to the items
*/
void AssignUserIcons() {
  static const char *L_folder_xpm[] = {
      "11 11 3 1",
      ".  c None",
      "x  c #d8d833",
      "@  c #808011",
      "...........",
      ".....@@@@..",
      "....@xxxx@.",
      "@@@@@xxxx@@",
      "@xxxxxxxxx@",
      "@xxxxxxxxx@",
      "@xxxxxxxxx@",
      "@xxxxxxxxx@",
      "@xxxxxxxxx@",
      "@xxxxxxxxx@",
      "@@@@@@@@@@@"};
  static Fl_Pixmap L_folderpixmap(L_folder_xpm);
  
  static const char *L_document_xpm[] = {
      "11 11 3 1",
      ".  c None",
      "x  c #d8d8f8",
      "@  c #202060",
      ".@@@@@@@@@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@xxxxxxx@.",
      ".@@@@@@@@@."};
  static Fl_Pixmap L_documentpixmap(L_document_xpm);
  
  // Assign user icons to tree items
  for ( Fl_Tree_Item *item = tree->first(); item; item=item->next())
      if ( usericon_radio->value() )
          // Assign custom icons
          item->usericon(item->has_children() ? &L_folderpixmap : &L_documentpixmap);
      else
      	// Don't assign custom icons
          item->usericon(0);
  
  tree->redraw();
}

/**
   Rebuild the 'example tree' from scratch
*/
void RebuildTree() {
  // REBUILD THE TREE TO MAKE CURRENT "DEFAULT" PREFS TAKE EFFECT
  tree->clear();
  tree->add("Aaa");
  tree->add("Bbb");
  tree->add("Ccc");
  tree->add("Ddd");
  tree->add("Bbb/child-01");
  tree->add("Bbb/child-01/111");
  tree->add("Bbb/child-01/222");
  tree->add("Bbb/child-01/333");
  tree->add("Bbb/child-02");
  tree->add("Bbb/child-03");
  tree->add("Bbb/child-04");
  
  {
      static Fl_Button *but = 0;
      // Assign an FLTK widget to one of the items
      Fl_Tree_Item *i;
      if ( ( i = tree->find_item("Bbb/child-03") ) != NULL ) {
          if ( !but ) {		// only do this once at program startup
              tree->begin();
              but = new Fl_Button(1,1,140,1,"ccc button");     // we control w() only
              but->labelsize(10);
  	    but->callback(Button_CB);
          }
          i->widget(but);
          tree->end();
      }
  }
  {
      // Assign an FLTK group to one of the items with widgets
      Fl_Tree_Item *i;
      if ( ( i = tree->find_item("Bbb/child-04") ) != NULL ) {
          static Fl_Group *grp = 0;
          if ( !grp ) {		// only do this once at program startup
              tree->begin();
                grp = new Fl_Group(100,100,140,18); // build group.. tree handles position
                grp->color(FL_WHITE);
                grp->begin();
                  Fl_Button *abut = new Fl_Button(grp->x()+0 ,grp->y()+2,65,15,"D1");
                  abut->labelsize(10);
  		abut->callback(Button_CB);
                  Fl_Button *bbut = new Fl_Button(grp->x()+75,grp->y()+2,65,15,"D2");
                  bbut->labelsize(10);
  		bbut->callback(Button_CB);
                grp->end();
                grp->resizable(grp);
              tree->end();
          }
          i->widget(grp);
      }
  }
  
  // Add an 'Ascending' node, and create it sorted
  tree->sortorder(FL_TREE_SORT_NONE);
  tree->add("Ascending")->close();
  tree->sortorder(FL_TREE_SORT_ASCENDING);
  tree->add("Ascending/Zzz");
  tree->add("Ascending/Xxx");
  tree->add("Ascending/Aaa");
  tree->add("Ascending/Bbb");
  tree->add("Ascending/Yyy");
  tree->add("Ascending/Ccc");
  
  // Add a 'Descending' node, and create it sorted
  tree->sortorder(FL_TREE_SORT_NONE);
  tree->add("Descending")->close();
  tree->sortorder(FL_TREE_SORT_DESCENDING);
  tree->add("Descending/Zzz");
  tree->add("Descending/Xxx");
  tree->add("Descending/Aaa");
  tree->add("Descending/Bbb");
  tree->add("Descending/Yyy");
  tree->add("Descending/Ccc");
  
  // Add 500 items in numerical order
  tree->sortorder(FL_TREE_SORT_NONE);
  for ( int t=0; t<500; t++ ) {
      static char s[80];
      sprintf(s, "500 Items/item %04d", t);
      tree->add(s);
  }
  tree->close("500 Items");	// close the 500 items by default
  
  AssignUserIcons();
  
  tree->redraw();
}

/**
   Prompt the user to change the specified color
*/
Fl_Color EditColor(Fl_Color val) {
  uchar r,g,b;
  // Get the current color
  Fl::get_color(val,r,g,b);
  
  // Bring up a color chooser to edit it
  fl_color_chooser("Choose Color",r,g,b);
  
  // Return the new color the user picked
  return(fl_rgb_color(r,g,b));
}

Fl_Double_Window *window=(Fl_Double_Window *)0;

Fl_Tree *tree=(Fl_Tree *)0;

static void cb_tree(Fl_Tree*, void*) {
  G_cb_counter++; // Increment callback counter whenever tree callback is invoked

Fl_Tree_Item *item = tree->callback_item();
if ( item ) {
  fprintf(stderr, "TREE CALLBACK: label='%s' userdata=%ld reason=%s\n",
          item->label(),
          (long)(fl_intptr_t)tree->user_data(),
	  reason_as_name(tree->callback_reason()));
} else {
  fprintf(stderr, "TREE CALLBACK: reason=%s item=(no item -- probably multiple items were changed at once)\n",
          reason_as_name(tree->callback_reason()));
};
}

Fl_Value_Slider *margintop_slider=(Fl_Value_Slider *)0;

static void cb_margintop_slider(Fl_Value_Slider*, void*) {
  int val = (int)margintop_slider->value();
tree->margintop(val);
tree->redraw();
}

Fl_Value_Slider *marginleft_slider=(Fl_Value_Slider *)0;

static void cb_marginleft_slider(Fl_Value_Slider*, void*) {
  int val = (int)marginleft_slider->value();
tree->marginleft(val);
tree->redraw();
}

Fl_Value_Slider *openchild_marginbottom_slider=(Fl_Value_Slider *)0;

static void cb_openchild_marginbottom_slider(Fl_Value_Slider*, void*) {
  int val = (int)openchild_marginbottom_slider->value();
tree->openchild_marginbottom(val);
tree->redraw();
}

Fl_Choice *collapseicons_chooser=(Fl_Choice *)0;

static void cb_collapseicons_chooser(Fl_Choice*, void*) {
  static const char *L_open_xpm[] = {
#ifdef __APPLE__
  "11 11 3 1",
  ".	c #fefefe",
  "#	c #444444",
  "@	c #000000",
  "###########",
  "#.........#",
  "#.........#",
  "#....@....#",
  "#....@....#",
  "#..@@@@@..#",
  "#....@....#",
  "#....@....#",
  "#.........#",
  "#.........#",
  "###########"
#else
    "11 11 2 1",
    ".  c None",
    "@  c #000000",
    "...@.......",
    "...@@......",
    "...@@@.....",
    "...@@@@....",
    "...@@@@@...",
    "...@@@@@@..",
    "...@@@@@...",
    "...@@@@....",
    "...@@@.....",
    "...@@......",
    "...@......."
#endif
    };
static Fl_Pixmap L_openpixmap(L_open_xpm);

static const char *L_close_xpm[] = {
#ifdef __APPLE__
  "11 11 3 1",
  ".	c #fefefe",
  "#	c #444444",
  "@	c #000000",
  "###########",
  "#.........#",
  "#.........#",
  "#.........#",
  "#.........#",
  "#..@@@@@..#",
  "#.........#",
  "#.........#",
  "#.........#",
  "#.........#",
  "###########"
#else
    "11 11 2 1",
    ".  c None",
    "@  c #000000",
    "...........",
    "...........",
    "...........",
    "...........",
    "...........",
    "@@@@@@@@@@@",
    ".@@@@@@@@@.",
    "..@@@@@@@..",
    "...@@@@@...",
    "....@@@....",
    ".....@....."
#endif
    };
static Fl_Pixmap L_closepixmap(L_close_xpm);

switch ( collapseicons_chooser->value() ) {
    case 0:
        tree->showcollapse(1);
        tree->openicon(0);
        tree->closeicon(0);
        break;
    case 1:
        tree->showcollapse(1);
        tree->openicon(&L_openpixmap);
        tree->closeicon(&L_closepixmap);
        break;
    case 2:
        tree->showcollapse(0);
        break;
};
}

Fl_Menu_Item menu_collapseicons_chooser[] = {
 {"Normal", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Custom", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Off", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *connectorstyle_chooser=(Fl_Choice *)0;

static void cb_connectorstyle_chooser(Fl_Choice*, void*) {
  // CHANGE COLLAPSESTYLE
switch ( connectorstyle_chooser->value() ) {
    case 0: tree->connectorstyle(FL_TREE_CONNECTOR_NONE);     break;
    case 1: tree->connectorstyle(FL_TREE_CONNECTOR_DOTTED);   break;
    case 2: tree->connectorstyle(FL_TREE_CONNECTOR_SOLID);    break;
};
}

Fl_Menu_Item menu_connectorstyle_chooser[] = {
 {"None", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Dotted", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Solid", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *selectmode_chooser=(Fl_Choice *)0;

static void cb_selectmode_chooser(Fl_Choice*, void*) {
  // Set selection mode
switch ( selectmode_chooser->value() ) {
    case 0:  tree->selectmode(FL_TREE_SELECT_NONE);   break;	// None
    case 1:  tree->selectmode(FL_TREE_SELECT_SINGLE); break;	// Single
    case 2:  tree->selectmode(FL_TREE_SELECT_MULTI);  break; 	// Multi
    default: tree->selectmode(FL_TREE_SELECT_SINGLE); break;	// Single
};
}

Fl_Menu_Item menu_selectmode_chooser[] = {
 {"None", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Single", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Multi", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Choice *whenmode_chooser=(Fl_Choice *)0;

static void cb_whenmode_chooser(Fl_Choice*, void*) {
  // Set when mode
switch ( whenmode_chooser->value() ) {
  case 0:  tree->when(FL_WHEN_RELEASE);   break;
  case 1:  tree->when(FL_WHEN_CHANGED);   break;
  case 2:  tree->when(FL_WHEN_NEVER);     break;
  default: tree->when(FL_WHEN_RELEASE);   break;
};
}

Fl_Menu_Item menu_whenmode_chooser[] = {
 {"Changed", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Released", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Never", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Check_Button *usericon_radio=(Fl_Check_Button *)0;

static void cb_usericon_radio(Fl_Check_Button*, void*) {
  AssignUserIcons();
}

Fl_Check_Button *showroot_radio=(Fl_Check_Button *)0;

static void cb_showroot_radio(Fl_Check_Button*, void*) {
  int onoff = showroot_radio->value();
tree->showroot(onoff);
}

Fl_Check_Button *visiblefocus_checkbox=(Fl_Check_Button *)0;

static void cb_visiblefocus_checkbox(Fl_Check_Button*, void*) {
  int onoff = visiblefocus_checkbox->value();
tree->visible_focus(onoff);
}

Fl_Button *selection_color_button=(Fl_Button *)0;

static void cb_selection_color_button(Fl_Button*, void*) {
  Fl_Color val = EditColor(tree->selection_color());		// Get color of first item in tree
selection_color_button->color(val);	// update modified color to button
tree->selection_color(val);
tree->redraw();
}

Fl_Box *showitem_box=(Fl_Box *)0;

static void cb_Show(Fl_Button*, void*) {
  Fl_Tree_Item *item = tree->next_selected_item();
tree->show_item(item);
}

static void cb_Top(Fl_Button*, void*) {
  Fl_Tree_Item *item = tree->next_selected_item();
tree->show_item_top(item);
}

static void cb_Mid(Fl_Button*, void*) {
  Fl_Tree_Item *item = tree->next_selected_item();
tree->show_item_middle(item);
}

static void cb_Bot(Fl_Button*, void*) {
  Fl_Tree_Item *item = tree->next_selected_item();
tree->show_item_bottom(item);
}

Fl_Button *loaddb_button=(Fl_Button *)0;

static void cb_loaddb_button(Fl_Button*, void*) {
  const char *filename = fl_file_chooser("Select a Preferences style Database", "Preferences(*.prefs)", 0L);
if (filename) {
  tree->clear();
  Fl_Preferences prefs(filename, 0L, 0L);
  tree->load(prefs);
  tree->redraw();
};
}

Fl_Button *insertabove_button=(Fl_Button *)0;

static void cb_insertabove_button(Fl_Button*, void*) {
  Fl_Tree_Item *item=tree->first();
while (item) {
    if ( item->is_selected() ) {
        tree->insert_above(item, "AaaAaa");
        tree->insert_above(item, "BbbBbb");
        tree->insert_above(item, "CccCcc");
    }
    item = item->next();
}

tree->redraw();
}

Fl_Button *rebuildtree_button=(Fl_Button *)0;

static void cb_rebuildtree_button(Fl_Button*, void*) {
  RebuildTree();
}

Fl_Button *showpathname_button=(Fl_Button *)0;

static void cb_showpathname_button(Fl_Button*, void*) {
  Fl_Tree_Item *item = tree->first_selected_item();
if ( !item ) { fl_message("No item was selected"); return; }

char pathname[256];
switch ( tree->item_pathname(pathname, sizeof(pathname), item) ) {
    case  0: fl_message("Pathname for '%s' is: \"%s\"", (item->label() ? item->label() : "???"), pathname); break;
    case -1: fl_message("item_pathname() returned -1 (NOT FOUND)"); break;
    case -2: fl_message("item_pathname() returned -2 (STRING TOO LONG)"); break;
};
}

Fl_Button *clearall_button=(Fl_Button *)0;

static void cb_clearall_button(Fl_Button*, void*) {
  tree->clear();
tree->redraw();
}

Fl_Button *testcallbackflag_button=(Fl_Button *)0;

static void cb_testcallbackflag_button(Fl_Button*, void*) {
  Fl_Tree_Item *root = tree->root();
fprintf(stderr, "--- Checking docallback off\n");
if (!root) return;

//// "OFF" TEST

// open/close: Make sure these methods don't trigger cb
G_cb_counter = 0; tree->close(root, 0);       if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n close(item) triggered cb!");
G_cb_counter = 0; tree->open(root, 0);        if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n open(item) triggered cb!");
G_cb_counter = 0; tree->open_toggle(root, 0); if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n open_toggle(item) triggered cb!");
G_cb_counter = 0; tree->open("ROOT", 0);      if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n open(path) triggered cb!");
G_cb_counter = 0; tree->close("ROOT", 0);     if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n close(path) triggered cb!");
tree->open(root,0);	// leave root open

// select/deselect: Make sure these methods don't trigger cb
G_cb_counter = 0; tree->select(root, 0);        if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n select(item) triggered cb!");
G_cb_counter = 0; tree->deselect(root, 0);      if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n deselect(item) triggered cb!");
G_cb_counter = 0; tree->select_toggle(root, 0); if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n select_toggle(item) triggered cb!");
G_cb_counter = 0; tree->deselect("ROOT", 0);    if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n deselect(path) triggered cb!");
G_cb_counter = 0; tree->select("ROOT", 0);      if ( G_cb_counter ) fl_alert("FAILED 'OFF' TEST\n select(path) triggered cb!");
tree->deselect("ROOT"); // leave deselected

//// "ON" TEST

// open/close: Make sure these methods don't trigger cb
G_cb_counter = 0; tree->close(root, 1);       if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n close(item) cb wasn't triggered!");
G_cb_counter = 0; tree->open(root, 1);        if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n open(item) cb wasn't triggered!");
G_cb_counter = 0; tree->open_toggle(root, 1); if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n open_toggle(item) cb wasn't triggered!");
G_cb_counter = 0; tree->open(root, 1);        if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n open(item)[2] cb wasn't triggered!");
G_cb_counter = 0; tree->close(root, 1);       if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n close(item)[2] cb wasn't triggered!");
G_cb_counter = 0; tree->open("ROOT", 1);      if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n open(path) cb wasn't triggered!");
G_cb_counter = 0; tree->close("ROOT", 1);     if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n close(path) cb wasn't triggered!");
tree->open(root,0);	// leave root open

// select/deselect: Make sure these methods don't trigger cb
G_cb_counter = 0; tree->select(root, 1);        if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n select(item) cb wasn't triggered!");
G_cb_counter = 0; tree->deselect(root, 1);      if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n deselect(item) cb wasn't triggered!");
G_cb_counter = 0; tree->select_toggle(root, 1); if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n select_toggle(item) cb wasn't triggered!");
G_cb_counter = 0; tree->deselect("ROOT", 1);    if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n deselect(path) cb wasn't triggered!");
G_cb_counter = 0; tree->select("ROOT", 1);      if ( !G_cb_counter ) fl_alert("FAILED 'ON' TEST\n select(path) cb wasn't triggered!");
tree->deselect("ROOT"); // leave deselected

//// "default" TEST (should be same as 'on'

// open/close: Make sure these methods don't trigger cb
G_cb_counter = 0; tree->close(root);       if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST: close(item) cb wasn't triggered!");
G_cb_counter = 0; tree->open(root);        if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST: open(item) cb wasn't triggered!");
G_cb_counter = 0; tree->open_toggle(root); if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST: open_toggle(item) cb wasn't triggered!");
G_cb_counter = 0; tree->open("ROOT");      if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST: open(path) cb wasn't triggered!");
G_cb_counter = 0; tree->close("ROOT");     if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST: close(path) cb wasn't triggered!");
tree->open(root,0);	// leave root open

// select/deselect: Make sure these methods don't trigger cb
G_cb_counter = 0; tree->select(root);        if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST\n select(item) cb wasn't triggered!");
G_cb_counter = 0; tree->deselect(root);      if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST\n deselect(item) cb wasn't triggered!");
G_cb_counter = 0; tree->select_toggle(root); if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST\n select_toggle(item) cb wasn't triggered!");
G_cb_counter = 0; tree->deselect("ROOT");    if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST\n deselect(path) cb wasn't triggered!");
G_cb_counter = 0; tree->select("ROOT");      if ( !G_cb_counter ) fl_alert("FAILED 'DEFAULT' TEST\n select(path) cb wasn't triggered!");
tree->deselect("ROOT"); // leave deselected

fl_alert("TEST COMPLETED\n If you didn't see any error dialogs, test PASSED.");
}

Fl_Choice *all_font_choice=(Fl_Choice *)0;

static void cb_all_font_choice(Fl_Choice*, void*) {
  // Find first item in tree
Fl_Tree_Item *item = tree->first();
if ( !item ) return;

// Get first item's font.
Fl_Font val = (Fl_Font)all_font_choice->value(); // Get font value

// Do selected items
int count = 0;
for ( item=tree->first(); item; item = tree->next(item) ) {
    if ( item->is_selected() ) {
        item->labelfont(val);
        count++;
    }
}

// No items selected? Do all..
if ( ! count ) {
    for ( item=tree->first(); item; item = tree->next(item) ) {
        item->labelfont(val);
    }
}

tree->redraw();
}

Fl_Menu_Item menu_all_font_choice[] = {
 {"Helvetica", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Helvetica Bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Helvetica Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Helvetica Bold Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier Bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier Bold Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times Bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times Bold Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Symbol", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Screen", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Screen bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Zapf Dingbats", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Value_Slider *labelsize_slider=(Fl_Value_Slider *)0;

static void cb_labelsize_slider(Fl_Value_Slider*, void*) {
  int size = (int)labelsize_slider->value();

// DO SELECTED ITEMS
int count = 0;
Fl_Tree_Item *item;
for ( item=tree->first(); item; item = tree->next(item) ) {
    if ( item->is_selected() ) {
        item->labelsize(size);
        count++;
    }
}

// NO ITEMS SELECTED? DO ALL
if ( ! count ) {
    for ( item=tree->first(); item; item = tree->next(item) ) {
        item->labelsize(size);
    }
}

tree->redraw();
}

Fl_Button *all_labelfgcolor_button=(Fl_Button *)0;

static void cb_all_labelfgcolor_button(Fl_Button*, void*) {
  // Find first item in tree
Fl_Tree_Item *item = tree->first();
if ( !item ) return;

// Get first item's color
Fl_Color val = EditColor(item->labelfgcolor());		// Get color of first item in tree
all_labelfgcolor_button->color(val);			// update modified color to button

// Do selected items
int count = 0;
for ( item=tree->first(); item; item = tree->next(item) ) {
    if ( item->is_selected() ) {
        item->labelfgcolor(val);
        count++;
    }
}

// No items selected? Do all..
if ( ! count ) {
    for ( item=tree->first(); item; item = tree->next(item) ) {
        item->labelfgcolor(val);
    }
}

tree->redraw();
}

Fl_Button *all_labelbgcolor_button=(Fl_Button *)0;

static void cb_all_labelbgcolor_button(Fl_Button*, void*) {
  // Find first item in tree
Fl_Tree_Item *item = tree->first();
if ( !item ) return;

// Get first item's color
Fl_Color val = EditColor(item->labelbgcolor());		// Get color of first item in tree
all_labelbgcolor_button->color(val);			// update modified color to button

// Do selected items
int count = 0;
for ( item=tree->first(); item; item = tree->next(item) ) {
    if ( item->is_selected() ) {
        item->labelbgcolor(val);
        count++;
    }
}

// No items selected? Do all..
if ( ! count ) {
    for ( item=tree->first(); item; item = tree->next(item) ) {
        item->labelbgcolor(val);
    }
}

tree->redraw();
}

Fl_Value_Slider *connectorwidth_slider=(Fl_Value_Slider *)0;

static void cb_connectorwidth_slider(Fl_Value_Slider*, void*) {
  tree->connectorwidth((int)connectorwidth_slider->value());
}

Fl_Light_Button *deactivate_toggle=(Fl_Light_Button *)0;

static void cb_deactivate_toggle(Fl_Light_Button*, void*) {
  int onoff = deactivate_toggle->value() ? 0 : 1;

Fl_Tree_Item *item;
int count = 0;
for ( item=tree->first(); item; item = tree->next(item) ) {
    if ( item->is_selected() ) {
        item->activate(onoff);
        ++count;
    }
}

if ( count == 0 ) {
    for ( item=tree->first(); item; item = tree->next(item) ) {
        item->activate(onoff);
    }
}

tree->redraw();
}

Fl_Light_Button *bold_toggle=(Fl_Light_Button *)0;

static void cb_bold_toggle(Fl_Light_Button*, void*) {
  int face = bold_toggle->value() ? FL_HELVETICA_BOLD : FL_HELVETICA;

// DO SELECTED ITEMS
int count = 0;
Fl_Tree_Item *item;
for ( item=tree->first(); item; item = tree->next(item) ) {
    if ( item->is_selected() ) {
        item->labelfont(face);
        count++;
    }
}

// NO ITEMS SELECTED? DO ALL
if ( ! count ) {
    for ( item=tree->first(); item; item = tree->next(item) ) {
        item->labelfont(face);
    }
}

tree->redraw();
}

Fl_Button *showselected_button=(Fl_Button *)0;

static void cb_showselected_button(Fl_Button*, void*) {
  fprintf(stderr, "--- SELECTED ITEMS\n");
for ( Fl_Tree_Item *item = tree->first_selected_item();
      item;
      item = tree->next_selected_item(item) ) {
  fprintf(stderr, "\t%s\n", item->label() ? item->label() : "???");
};
}

Fl_Button *clearselected_button=(Fl_Button *)0;

static void cb_clearselected_button(Fl_Button*, void*) {
  Fl_Tree_Item *item=tree->first();
while (item) {
    if ( item->is_selected() ) {
    	if ( tree->remove(item) == -1 ) break;
    	item = tree->first();
    } else {
        item = item->next();
    }
}

tree->redraw();
}

Fl_Button *selectall_button=(Fl_Button *)0;

static void cb_selectall_button(Fl_Button*, void*) {
  tree->select_all(0);
tree->redraw();
}

Fl_Button *deselectall_button=(Fl_Button *)0;

static void cb_deselectall_button(Fl_Button*, void*) {
  tree->deselect_all(0);
tree->redraw();
}

Fl_Light_Button *bbbselect_toggle=(Fl_Light_Button *)0;

static void cb_bbbselect_toggle(Fl_Light_Button*, void*) {
  // Toggle select of just the Bbb item (not children)
Fl_Tree_Item *bbb = tree->find_item("/Bbb");
if ( !bbb) {
  fl_alert("FAIL: Couldn't find item '/Bbb'???");
  return;
}
int onoff = bbbselect_toggle->value();
if ( onoff ) tree->select(bbb);		// select /Bbb
else         tree->deselect(bbb);	// deselect /Bbb;
}

Fl_Light_Button *bbbselect2_toggle=(Fl_Light_Button *)0;

static void cb_bbbselect2_toggle(Fl_Light_Button*, void*) {
  // Toggle select of just the Bbb item and its immediate children
Fl_Tree_Item *bbb = tree->find_item("/Bbb");
if ( !bbb) {
  fl_alert("FAIL: Couldn't find item '/Bbb'???");
  return;
}
int onoff = bbbselect2_toggle->value();
if ( onoff ) tree->select_all(bbb);		// select /Bbb and its children
else         tree->deselect_all(bbb);	// deselect /Bbb and its children;
}

Fl_Light_Button *bbbchild02select_toggle=(Fl_Light_Button *)0;

static void cb_bbbchild02select_toggle(Fl_Light_Button*, void*) {
  // Toggle select of just the /Bbb/child-02 item
const char *pathname = "/Bbb/child-02";
int onoff = bbbchild02select_toggle->value();
int err = 0;
if ( onoff ) err = tree->select(pathname);
else         err = tree->deselect(pathname);

if ( err == -1 ) {
  fl_alert("FAIL: Couldn't find item '%s'",pathname);
  return;
};
}

Fl_Light_Button *rootselect_toggle=(Fl_Light_Button *)0;

static void cb_rootselect_toggle(Fl_Light_Button*, void*) {
  // Toggle select of ROOT item and its children
Fl_Tree_Item *item = tree->find_item("/ROOT");
if ( !item) {
  fl_alert("FAIL: Couldn't find item '/ROOT'???");
  return;
}
int onoff = rootselect_toggle->value();
if ( onoff ) tree->select(item);	// select /ROOT and its children
else         tree->deselect(item);	// deselect /ROOT and its children;
}

Fl_Light_Button *rootselect2_toggle=(Fl_Light_Button *)0;

static void cb_rootselect2_toggle(Fl_Light_Button*, void*) {
  // Toggle select of ROOT item and its children
Fl_Tree_Item *item = tree->find_item("/ROOT");
if ( !item) {
  fl_alert("FAIL: Couldn't find item '/ROOT'???");
  return;
}
int onoff = rootselect2_toggle->value();
if ( onoff ) tree->select_all(item);	// select /ROOT and its children
else         tree->deselect_all(item);	// deselect /ROOT and its children;
}

Fl_Button *item_labelfgcolor_button=(Fl_Button *)0;

static void cb_item_labelfgcolor_button(Fl_Button*, void*) {
  Fl_Color val = EditColor(tree->item_labelfgcolor());	// Let user edit the color
tree->item_labelfgcolor(val);				// apply modified color to tree
item_labelfgcolor_button->color(val);			// update modified color to button;
}

Fl_Button *item_labelbgcolor_button=(Fl_Button *)0;

static void cb_item_labelbgcolor_button(Fl_Button*, void*) {
  Fl_Color val = EditColor(tree->item_labelbgcolor());	// Let user edit the color
tree->item_labelbgcolor(val);				// apply modified color to tree
item_labelbgcolor_button->color(val);			// update modified color to button;
}

Fl_Choice *item_font_choice=(Fl_Choice *)0;

static void cb_item_font_choice(Fl_Choice*, void*) {
  Fl_Font val = (Fl_Font)item_font_choice->value(); // get chooser's current font value
tree->item_labelfont(val);			  // change font in tree;
}

Fl_Menu_Item menu_item_font_choice[] = {
 {"Helvetica", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Helvetica Bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Helvetica Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Helvetica Bold Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier Bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Courier Bold Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times Bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Times Bold Italic", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Symbol", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Screen", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Screen bold", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {"Zapf Dingbats", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 12, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Value_Slider *item_labelsize_slider=(Fl_Value_Slider *)0;

static void cb_item_labelsize_slider(Fl_Value_Slider*, void*) {
  tree->item_labelsize((int)item_labelsize_slider->value());
}

Fl_Box *resizer_box=(Fl_Box *)0;

int main(int argc, char **argv) {
  { window = new Fl_Double_Window(1015, 445, "tree");
    { tree = new Fl_Tree(15, 22, 280, 411, "Tree");
      tree->tooltip("Test tree");
      tree->box(FL_DOWN_BOX);
      tree->color((Fl_Color)55);
      tree->selection_color(FL_SELECTION_COLOR);
      tree->labeltype(FL_NORMAL_LABEL);
      tree->labelfont(0);
      tree->labelsize(14);
      tree->labelcolor(FL_FOREGROUND_COLOR);
      tree->callback((Fl_Callback*)cb_tree, (void*)(1234));
      tree->align(Fl_Align(FL_ALIGN_TOP));
      tree->when(FL_WHEN_RELEASE);
      tree->end();
    } // Fl_Tree* tree
    { Fl_Group* o = new Fl_Group(300, 5, 705, 427);
      { Fl_Box* o = new Fl_Box(311, 23, 335, 263, "Tree Globals");
        o->tooltip("These controls only affect the selected items. If no items are selected, all \
existing items in tree are modified.");
        o->box(FL_DOWN_BOX);
        o->color(FL_DARK1);
        o->labelsize(12);
        o->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Box* o
      { Fl_Value_Slider* o = margintop_slider = new Fl_Value_Slider(486, 31, 140, 16, "margintop()");
        margintop_slider->tooltip("Changes the top margin for the tree widget");
        margintop_slider->type(1);
        margintop_slider->labelsize(12);
        margintop_slider->textsize(12);
        margintop_slider->callback((Fl_Callback*)cb_margintop_slider, (void*)(tree));
        margintop_slider->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(tree->margintop());
        o->range(0.0, 100.0);
        o->step(1.0);
        o->color(46); o->selection_color(FL_RED);
      } // Fl_Value_Slider* margintop_slider
      { Fl_Value_Slider* o = marginleft_slider = new Fl_Value_Slider(486, 51, 140, 16, "marginleft()");
        marginleft_slider->tooltip("Changes the left margin for the tree widget");
        marginleft_slider->type(1);
        marginleft_slider->labelsize(12);
        marginleft_slider->textsize(12);
        marginleft_slider->callback((Fl_Callback*)cb_marginleft_slider, (void*)(tree));
        marginleft_slider->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(tree->marginleft());
        o->range(0.0, 100.0);
        o->step(1.0);
        o->color(46); o->selection_color(FL_RED);
      } // Fl_Value_Slider* marginleft_slider
      { Fl_Value_Slider* o = openchild_marginbottom_slider = new Fl_Value_Slider(486, 71, 140, 16, "openchild_marginbottom()");
        openchild_marginbottom_slider->tooltip("Changes the vertical space below an open child tree");
        openchild_marginbottom_slider->type(1);
        openchild_marginbottom_slider->labelsize(12);
        openchild_marginbottom_slider->textsize(12);
        openchild_marginbottom_slider->callback((Fl_Callback*)cb_openchild_marginbottom_slider, (void*)(tree));
        openchild_marginbottom_slider->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(tree->openchild_marginbottom());
        o->range(0.0, 100.0);
        o->step(1.0);
        o->color(46); o->selection_color(FL_RED);
      } // Fl_Value_Slider* openchild_marginbottom_slider
      { collapseicons_chooser = new Fl_Choice(486, 96, 140, 21, "Collapse icons");
        collapseicons_chooser->tooltip("Tests Fl_Tree::openicon() and Fl_Tree::closeicon()");
        collapseicons_chooser->down_box(FL_BORDER_BOX);
        collapseicons_chooser->labelsize(12);
        collapseicons_chooser->textsize(11);
        collapseicons_chooser->callback((Fl_Callback*)cb_collapseicons_chooser);
        collapseicons_chooser->menu(menu_collapseicons_chooser);
      } // Fl_Choice* collapseicons_chooser
      { connectorstyle_chooser = new Fl_Choice(486, 120, 140, 21, "Line style");
        connectorstyle_chooser->tooltip("Tests connectorstyle() bit flags");
        connectorstyle_chooser->down_box(FL_BORDER_BOX);
        connectorstyle_chooser->labelsize(12);
        connectorstyle_chooser->textsize(11);
        connectorstyle_chooser->callback((Fl_Callback*)cb_connectorstyle_chooser);
        connectorstyle_chooser->menu(menu_connectorstyle_chooser);
        switch (tree->connectorstyle()) { case FL_TREE_CONNECTOR_NONE: connectorstyle_chooser->value(0); break; case FL_TREE_CONNECTOR_DOTTED: connectorstyle_chooser->value(1); break; case FL_TREE_CONNECTOR_SOLID: connectorstyle_chooser->value(2); break; }
      } // Fl_Choice* connectorstyle_chooser
      { selectmode_chooser = new Fl_Choice(486, 144, 140, 21, "Selection Mode");
        selectmode_chooser->tooltip("Sets how Fl_Tree handles mouse selection of tree items");
        selectmode_chooser->down_box(FL_BORDER_BOX);
        selectmode_chooser->labelsize(12);
        selectmode_chooser->textsize(11);
        selectmode_chooser->callback((Fl_Callback*)cb_selectmode_chooser);
        selectmode_chooser->menu(menu_selectmode_chooser);
        selectmode_chooser->value(1);
        cb_selectmode_chooser(selectmode_chooser, (void*)0);
      } // Fl_Choice* selectmode_chooser
      { whenmode_chooser = new Fl_Choice(486, 168, 140, 21, "When");
        whenmode_chooser->tooltip("Sets when() the tree\'s callback is invoked");
        whenmode_chooser->down_box(FL_BORDER_BOX);
        whenmode_chooser->labelsize(12);
        whenmode_chooser->textsize(11);
        whenmode_chooser->callback((Fl_Callback*)cb_whenmode_chooser);
        whenmode_chooser->menu(menu_whenmode_chooser);
        whenmode_chooser->value(1);
        cb_whenmode_chooser(whenmode_chooser, (void*)0);
      } // Fl_Choice* whenmode_chooser
      { usericon_radio = new Fl_Check_Button(486, 194, 20, 16, "Enable user icons?");
        usericon_radio->tooltip("Tests Fl_Tree_Item::usericon()");
        usericon_radio->down_box(FL_DOWN_BOX);
        usericon_radio->labelsize(12);
        usericon_radio->callback((Fl_Callback*)cb_usericon_radio, (void*)(tree));
        usericon_radio->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        usericon_radio->value(1);
      } // Fl_Check_Button* usericon_radio
      { showroot_radio = new Fl_Check_Button(486, 211, 20, 16, "Show root?");
        showroot_radio->tooltip("Tests tree->showroot();");
        showroot_radio->down_box(FL_DOWN_BOX);
        showroot_radio->labelsize(12);
        showroot_radio->callback((Fl_Callback*)cb_showroot_radio, (void*)(tree));
        showroot_radio->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        int onoff = tree->showroot(); showroot_radio->value(onoff);
      } // Fl_Check_Button* showroot_radio
      { visiblefocus_checkbox = new Fl_Check_Button(486, 228, 20, 16, "Visible focus?");
        visiblefocus_checkbox->tooltip("Toggles the tree\'s visible_focus() box");
        visiblefocus_checkbox->down_box(FL_DOWN_BOX);
        visiblefocus_checkbox->labelsize(12);
        visiblefocus_checkbox->callback((Fl_Callback*)cb_visiblefocus_checkbox, (void*)(tree));
        visiblefocus_checkbox->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        int onoff = tree->visible_focus(); visiblefocus_checkbox->value(onoff);
      } // Fl_Check_Button* visiblefocus_checkbox
      { Fl_Button* o = selection_color_button = new Fl_Button(486, 251, 16, 16, "Selection Color");
        selection_color_button->tooltip("Changes the tree widget\'s selection color. Tests Fl_Tree::selection_color()");
        selection_color_button->box(FL_DOWN_BOX);
        selection_color_button->labelsize(12);
        selection_color_button->callback((Fl_Callback*)cb_selection_color_button);
        selection_color_button->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        o->color(tree->selection_color());
      } // Fl_Button* selection_color_button
      { Fl_Box* o = new Fl_Box(311, 312, 335, 120, "Test Operations");
        o->tooltip("These controls only affect the defaults for new items that are created. These\
 test the Fl_Tree_Prefs methods.");
        o->box(FL_DOWN_BOX);
        o->color(FL_DARK1);
        o->labelsize(12);
        o->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Box* o
      { showitem_box = new Fl_Box(331, 335, 70, 82, "show_item()\n");
        showitem_box->box(FL_DOWN_BOX);
        showitem_box->labelsize(11);
        showitem_box->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Box* showitem_box
      { Fl_Button* o = new Fl_Button(346, 344, 40, 17, "Show");
        o->tooltip("Tests show_item() with no position specified.\nMakes the selected item visibl\
e IF it is off-screen.\nNo change made if it is not off-screen.");
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Show);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(346, 361, 40, 16, "Top");
        o->tooltip("Test show_item_top().\nScrolls selected item to the top of the display\n(only\
 works if scrollbar showing)\nTo use:\n1) open \'500 items\'\n2) select item 0\
010\n3) Hit Top/Mid/Bot");
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Top);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(346, 377, 40, 16, "Mid");
        o->tooltip("Tests show_item_middle().\nScrolls the selected item to the middle of the dis\
play\nTo use:\n  1) open \'500 items\'\n  2) select \'item 0010\'\n  3) Hit To\
p/Mid/Bot");
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Mid);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(346, 393, 40, 16, "Bot");
        o->tooltip("Tests show_item_bottom().\nScrolls the selected item to the bottom of the dis\
play\nTo use:\n  1) open \'500 items\'\n  2) select \'item 0010\'\n  3) Hit To\
p/Mid/Bot");
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_Bot);
      } // Fl_Button* o
      { loaddb_button = new Fl_Button(431, 338, 95, 16, "Load Database...");
        loaddb_button->tooltip("Load the contents of an Fl_Preferences database into the tree view");
        loaddb_button->labelsize(9);
        loaddb_button->callback((Fl_Callback*)cb_loaddb_button);
      } // Fl_Button* loaddb_button
      { insertabove_button = new Fl_Button(431, 358, 95, 16, "Insert Above");
        insertabove_button->tooltip("Inserts three items above the selected items");
        insertabove_button->labelsize(9);
        insertabove_button->callback((Fl_Callback*)cb_insertabove_button);
      } // Fl_Button* insertabove_button
      { rebuildtree_button = new Fl_Button(431, 378, 95, 16, "Rebuild Tree");
        rebuildtree_button->tooltip("Rebuilds the tree with defaults");
        rebuildtree_button->labelsize(9);
        rebuildtree_button->callback((Fl_Callback*)cb_rebuildtree_button);
      } // Fl_Button* rebuildtree_button
      { showpathname_button = new Fl_Button(431, 398, 95, 16, "Show Pathname");
        showpathname_button->tooltip("Show the pathname for the selected item. Tests the Fl_Tree::item_pathname() m\
ethod.");
        showpathname_button->labelsize(9);
        showpathname_button->callback((Fl_Callback*)cb_showpathname_button);
      } // Fl_Button* showpathname_button
      { clearall_button = new Fl_Button(531, 338, 95, 16, "Clear All");
        clearall_button->tooltip("Clears all items\nTests Fl_Tree::clear()");
        clearall_button->labelsize(9);
        clearall_button->callback((Fl_Callback*)cb_clearall_button);
      } // Fl_Button* clearall_button
      { testcallbackflag_button = new Fl_Button(531, 358, 95, 16, "Test Callback Flag");
        testcallbackflag_button->tooltip("Test the \'docallback\' argument can disable callbacks.");
        testcallbackflag_button->labelsize(9);
        testcallbackflag_button->callback((Fl_Callback*)cb_testcallbackflag_button);
      } // Fl_Button* testcallbackflag_button
      { Fl_Box* o = new Fl_Box(661, 23, 335, 263, "Selected Items");
        o->tooltip("These controls only affect the selected items. If no items are selected, all \
existing items in tree are modified.");
        o->box(FL_DOWN_BOX);
        o->color(FL_DARK1);
        o->labelsize(12);
        o->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Box* o
      { Fl_Choice* o = all_font_choice = new Fl_Choice(828, 31, 140, 21, "Label Font");
        all_font_choice->tooltip("Changes the font for the selected items\'s labels. If none selected, all are \
changed. Tests Fl_Tree_Item::labelfont();");
        all_font_choice->down_box(FL_BORDER_BOX);
        all_font_choice->labelsize(12);
        all_font_choice->textsize(11);
        all_font_choice->callback((Fl_Callback*)cb_all_font_choice);
        all_font_choice->menu(menu_all_font_choice);
        o->value((int)tree->item_labelfont());   // get tree's current font, assign to chooser
      } // Fl_Choice* all_font_choice
      { Fl_Value_Slider* o = labelsize_slider = new Fl_Value_Slider(828, 55, 140, 16, "Label Size");
        labelsize_slider->tooltip("Changes the font size of the selected items\'s labels. If none selected, all \
are changed. Tests Fl_Tree_Item::labelsize();");
        labelsize_slider->type(1);
        labelsize_slider->labelsize(12);
        labelsize_slider->textsize(12);
        labelsize_slider->callback((Fl_Callback*)cb_labelsize_slider, (void*)(tree));
        labelsize_slider->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(tree->item_labelsize());
        o->range(5.0, 200.0);
        o->step(1.0);
        o->color(46); o->selection_color(FL_RED);
      } // Fl_Value_Slider* labelsize_slider
      { Fl_Button* o = all_labelfgcolor_button = new Fl_Button(828, 81, 16, 16, "Label FG Color");
        all_labelfgcolor_button->tooltip("Changes the label fg color for the selected items. If none selected, all are \
changed. Tests Fl_Tree_Item::labelfgcolor();");
        all_labelfgcolor_button->box(FL_DOWN_BOX);
        all_labelfgcolor_button->labelsize(12);
        all_labelfgcolor_button->callback((Fl_Callback*)cb_all_labelfgcolor_button);
        all_labelfgcolor_button->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        o->color(tree->item_labelfgcolor());
      } // Fl_Button* all_labelfgcolor_button
      { Fl_Button* o = all_labelbgcolor_button = new Fl_Button(828, 99, 16, 16, "Label BG Color");
        all_labelbgcolor_button->tooltip("Changes the label bg color for the selected items. If none selected, all are \
changed. Tests Fl_Tree_Item::labelbgcolor();");
        all_labelbgcolor_button->box(FL_DOWN_BOX);
        all_labelbgcolor_button->labelsize(12);
        all_labelbgcolor_button->callback((Fl_Callback*)cb_all_labelbgcolor_button);
        all_labelbgcolor_button->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        o->color(tree->item_labelbgcolor());
      } // Fl_Button* all_labelbgcolor_button
      { Fl_Value_Slider* o = connectorwidth_slider = new Fl_Value_Slider(828, 126, 140, 16, "Connector Width");
        connectorwidth_slider->tooltip("Tests Fl_Tree::connectorwidth()");
        connectorwidth_slider->type(1);
        connectorwidth_slider->labelsize(12);
        connectorwidth_slider->textsize(12);
        connectorwidth_slider->callback((Fl_Callback*)cb_connectorwidth_slider, (void*)(tree));
        connectorwidth_slider->align(Fl_Align(FL_ALIGN_LEFT));
        o->value(tree->connectorwidth());
        o->range(1.0, 100.0);
        o->step(1.0);
        o->color(46); o->selection_color(FL_RED);
      } // Fl_Value_Slider* connectorwidth_slider
      { deactivate_toggle = new Fl_Light_Button(734, 154, 95, 16, " Deactivate");
        deactivate_toggle->tooltip("Toggle the deactivation state of the selected items.\nIf none are selected, a\
ll are set.");
        deactivate_toggle->selection_color((Fl_Color)1);
        deactivate_toggle->labelsize(9);
        deactivate_toggle->callback((Fl_Callback*)cb_deactivate_toggle);
      } // Fl_Light_Button* deactivate_toggle
      { bold_toggle = new Fl_Light_Button(734, 174, 95, 16, " Bold Font");
        bold_toggle->tooltip("Toggles bold font for selected items\nIf nothing selected, all are changed");
        bold_toggle->selection_color((Fl_Color)1);
        bold_toggle->labelsize(9);
        bold_toggle->callback((Fl_Callback*)cb_bold_toggle);
      } // Fl_Light_Button* bold_toggle
      { showselected_button = new Fl_Button(829, 154, 95, 16, "Show Selected");
        showselected_button->tooltip("Clears the selected items");
        showselected_button->labelsize(9);
        showselected_button->callback((Fl_Callback*)cb_showselected_button);
      } // Fl_Button* showselected_button
      { clearselected_button = new Fl_Button(829, 174, 95, 16, "Remove Selected");
        clearselected_button->tooltip("Removes the selected items");
        clearselected_button->labelsize(9);
        clearselected_button->callback((Fl_Callback*)cb_clearselected_button);
      } // Fl_Button* clearselected_button
      { selectall_button = new Fl_Button(689, 201, 95, 16, "Select All");
        selectall_button->tooltip("Selects all items in the tree");
        selectall_button->labelsize(9);
        selectall_button->callback((Fl_Callback*)cb_selectall_button);
      } // Fl_Button* selectall_button
      { deselectall_button = new Fl_Button(689, 221, 95, 16, "Deselect All");
        deselectall_button->tooltip("Deselects all items in the tree");
        deselectall_button->labelsize(9);
        deselectall_button->callback((Fl_Callback*)cb_deselectall_button);
      } // Fl_Button* deselectall_button
      { bbbselect_toggle = new Fl_Light_Button(784, 201, 95, 16, " Select Bbb");
        bbbselect_toggle->tooltip("Toggle selection of just the /Bbb item\n(Not children)");
        bbbselect_toggle->selection_color((Fl_Color)1);
        bbbselect_toggle->labelsize(9);
        bbbselect_toggle->callback((Fl_Callback*)cb_bbbselect_toggle);
      } // Fl_Light_Button* bbbselect_toggle
      { bbbselect2_toggle = new Fl_Light_Button(784, 221, 95, 16, " Select Bbb+");
        bbbselect2_toggle->tooltip("Toggle selection of the /Bbb item and its children");
        bbbselect2_toggle->selection_color((Fl_Color)1);
        bbbselect2_toggle->labelsize(9);
        bbbselect2_toggle->callback((Fl_Callback*)cb_bbbselect2_toggle);
      } // Fl_Light_Button* bbbselect2_toggle
      { bbbchild02select_toggle = new Fl_Light_Button(784, 241, 95, 16, " Toggle child-02");
        bbbchild02select_toggle->tooltip("Toggle the single item \"/Bbb/child-02\" using the item\'s \"pathname\".");
        bbbchild02select_toggle->selection_color((Fl_Color)1);
        bbbchild02select_toggle->labelsize(9);
        bbbchild02select_toggle->callback((Fl_Callback*)cb_bbbchild02select_toggle);
      } // Fl_Light_Button* bbbchild02select_toggle
      { rootselect_toggle = new Fl_Light_Button(879, 201, 95, 16, "Select ROOT");
        rootselect_toggle->tooltip("Toggle selection of the ROOT item");
        rootselect_toggle->selection_color((Fl_Color)1);
        rootselect_toggle->labelsize(9);
        rootselect_toggle->callback((Fl_Callback*)cb_rootselect_toggle);
      } // Fl_Light_Button* rootselect_toggle
      { rootselect2_toggle = new Fl_Light_Button(879, 221, 95, 16, "Select ROOT+");
        rootselect2_toggle->tooltip("Toggle selection of the ROOT item and all children");
        rootselect2_toggle->selection_color((Fl_Color)1);
        rootselect2_toggle->labelsize(9);
        rootselect2_toggle->callback((Fl_Callback*)cb_rootselect2_toggle);
      } // Fl_Light_Button* rootselect2_toggle
      { Fl_Box* o = new Fl_Box(661, 312, 335, 120, "New Item Defaults");
        o->tooltip("These controls only affect the defaults for new items that are created. These\
 test the Fl_Tree_Prefs methods.");
        o->box(FL_DOWN_BOX);
        o->color(FL_DARK1);
        o->labelsize(12);
        o->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Box* o
      { Fl_Button* o = item_labelfgcolor_button = new Fl_Button(828, 327, 16, 16, "item_labelfgcolor");
        item_labelfgcolor_button->tooltip("Sets the *default* label foreground color for new items created. Does NOT aff\
ect existing items.");
        item_labelfgcolor_button->box(FL_DOWN_BOX);
        item_labelfgcolor_button->labelsize(12);
        item_labelfgcolor_button->callback((Fl_Callback*)cb_item_labelfgcolor_button);
        item_labelfgcolor_button->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        o->color(tree->item_labelfgcolor());
      } // Fl_Button* item_labelfgcolor_button
      { item_labelbgcolor_button = new Fl_Button(828, 345, 16, 16, "item_labelbgcolor");
        item_labelbgcolor_button->tooltip("Sets the *default* label background color for new items created. Does NOT aff\
ect existing items.");
        item_labelbgcolor_button->box(FL_DOWN_BOX);
        item_labelbgcolor_button->labelsize(12);
        item_labelbgcolor_button->callback((Fl_Callback*)cb_item_labelbgcolor_button);
        item_labelbgcolor_button->align(Fl_Align(FL_ALIGN_LEFT_TOP));
        item_labelbgcolor_button->color(tree->item_labelbgcolor());
      } // Fl_Button* item_labelbgcolor_button
      { Fl_Choice* o = item_font_choice = new Fl_Choice(828, 371, 140, 21, "Item label font");
        item_font_choice->tooltip("Sets the default font used for new items created. Does NOT affect existing it\
ems.");
        item_font_choice->down_box(FL_BORDER_BOX);
        item_font_choice->labelsize(12);
        item_font_choice->textsize(12);
        item_font_choice->callback((Fl_Callback*)cb_item_font_choice);
        item_font_choice->menu(menu_item_font_choice);
        o->value((int)tree->item_labelfont());   // get tree's current font, assign to chooser
      } // Fl_Choice* item_font_choice
      { Fl_Value_Slider* o = item_labelsize_slider = new Fl_Value_Slider(828, 396, 140, 16, "item_labelsize");
        item_labelsize_slider->tooltip("Sets the default labelsize used for new items. Does NOT affect existing items\
.");
        item_labelsize_slider->type(1);
        item_labelsize_slider->labelsize(12);
        item_labelsize_slider->textsize(12);
        item_labelsize_slider->callback((Fl_Callback*)cb_item_labelsize_slider, (void*)(tree));
        item_labelsize_slider->align(Fl_Align(FL_ALIGN_LEFT));
        o->value((int)tree->item_labelsize());
        o->range(1.0, 50.0);
        o->step(1.0);
        o->color(46); o->selection_color(FL_RED);
      } // Fl_Value_Slider* item_labelsize_slider
      o->resizable(0);
      o->end();
    } // Fl_Group* o
    { resizer_box = new Fl_Box(0, 263, 15, 14);
    } // Fl_Box* resizer_box
    window->end();
  } // Fl_Double_Window* window
  // Initialize Tree
  tree->root_label("ROOT");
  RebuildTree();
  /*tree->show_self();*/
  // FLTK stuff
  
  //Fl::scheme("gtk+");
  
  window->resizable(tree);
  window->size_range(window->w(), window->h(), 0, 0);
  
       if ( tree->when() == FL_WHEN_CHANGED ) whenmode_chooser->value(0);
  else if ( tree->when() == FL_WHEN_RELEASE ) whenmode_chooser->value(1);
  else if ( tree->when() == FL_WHEN_NEVER   ) whenmode_chooser->value(2);
  window->show(argc, argv);
  return Fl::run();
}
